/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gl.texture;

import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.impl.texture.ITexture;
import io.homo.superresolution.core.impl.texture.TextureFormat;

public class GlTextureView
implements ITexture {
    private final ITexture parent;
    private final int type;
    private final int minLevel;
    private final int numLevels;
    private final int minLayer;
    private final int numLayers;
    private int id;

    private GlTextureView(ITexture parent, int type, int minLevel, int numLevels, int minLayer, int numLayers, int id) {
        this.parent = parent;
        this.type = type;
        this.minLevel = minLevel;
        this.numLevels = numLevels;
        this.minLayer = minLayer;
        this.numLayers = numLayers;
        this.id = id;
    }

    public static GlTextureView create(ITexture parent, int type, int minLevel, int numLevels, int minLayer, int numLayers) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent texture cannot be null");
        }
        if (parent.getTextureId() == 0) {
            throw new IllegalStateException("Parent texture is not initialized");
        }
        int viewId = Gl.DSA.createTextureView(parent.getTextureId(), type, parent.getTextureFormat().gl(), minLevel, numLevels, minLayer, numLayers);
        return new GlTextureView(parent, type, minLevel, numLevels, minLayer, numLayers, viewId);
    }

    public ITexture getParent() {
        return this.parent;
    }

    public int getType() {
        return this.type;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getNumLevels() {
        return this.numLevels;
    }

    public int getMinLayer() {
        return this.minLayer;
    }

    public int getNumLayers() {
        return this.numLayers;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    @Override
    public TextureFormat getTextureFormat() {
        return this.parent.getTextureFormat();
    }

    @Override
    public int getWidth() {
        return this.parent.getWidth();
    }

    @Override
    public int getHeight() {
        return this.parent.getHeight();
    }

    @Override
    public void destroy() {
        Gl.DSA.deleteTexture(this.id);
        this.id = -1;
    }

    @Override
    public void resize(int width, int height) {
        throw new RuntimeException("GlTextureView\u4e0d\u53ef\u66f4\u6539\u5927\u5c0f");
    }
}

