/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gl.vertex;

import io.homo.superresolution.core.gl.Gl;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;

public class GlVertexBuffer
implements AutoCloseable {
    private final int id = Gl.DSA.createBuffer();
    private int target;

    public void bind(int target) {
        this.target = target;
        Gl.glBindBuffer(target, this.id);
    }

    public void uploadData(float[] data, int usage) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)data.length);
        buffer.put(data).flip();
        Gl.DSA.bufferData(this.id, this.target, buffer, usage);
    }

    public void uploadData(int[] data, int usage) {
        IntBuffer buffer = BufferUtils.createIntBuffer((int)data.length);
        buffer.put(data).flip();
        Gl.DSA.bufferData(this.id, this.target, buffer, usage);
    }

    @Override
    public void close() {
        Gl.DSA.deleteBuffer(this.id);
    }

    public int getId() {
        return this.id;
    }
}

