/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.impl.texture;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum TextureFormat {
    RGBA8(32856, 37),
    RGBA16F(34842, 97),
    RGB8(32849, 23),
    RG16F(33327, 83),
    RG32F(33328, 103),
    RG8(33323, 16),
    R16F(33325, 76),
    R8(33321, 9),
    R32F(33326, 100),
    R32UI(33334, 98),
    DEPTH32F(36012, 126),
    DEPTH24_STENCIL8(35056, 129),
    DEPTH24(33190, 125),
    R16_SNORM(36760, 71),
    R11G11B10F(35898, 122);

    private static final Map<Integer, TextureFormat> GL_TO_FORMAT;
    private static final Map<Integer, TextureFormat> VK_TO_FORMAT;
    private final int glFormat;
    private final int vkFormat;

    private TextureFormat(int glFormat, int vkFormat) {
        this.glFormat = glFormat;
        this.vkFormat = vkFormat;
    }

    @NotNull
    public static TextureFormat fromVk(int format) {
        TextureFormat result = VK_TO_FORMAT.get(format);
        if (result == null) {
            throw new IllegalArgumentException("Unsupported Vulkan format: 0x" + Integer.toHexString(format).toUpperCase());
        }
        return result;
    }

    @NotNull
    public static TextureFormat fromGl(int format) {
        TextureFormat result = GL_TO_FORMAT.get(format);
        if (result == null) {
            throw new IllegalArgumentException("Unsupported OpenGL format: 0x" + Integer.toHexString(format).toUpperCase());
        }
        return result;
    }

    public boolean isStencil() {
        return this == DEPTH24_STENCIL8;
    }

    public int gl() {
        return this.glFormat;
    }

    public int vk() {
        return this.vkFormat;
    }

    static {
        HashMap<Integer, TextureFormat> glMap = new HashMap<Integer, TextureFormat>();
        HashMap<Integer, TextureFormat> vkMap = new HashMap<Integer, TextureFormat>();
        for (TextureFormat format : TextureFormat.values()) {
            glMap.put(format.glFormat, format);
            vkMap.put(format.vkFormat, format);
        }
        GL_TO_FORMAT = Collections.unmodifiableMap(glMap);
        VK_TO_FORMAT = Collections.unmodifiableMap(vkMap);
    }
}

