/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.interop.texture;

import io.homo.superresolution.core.impl.texture.TextureFormat;
import io.homo.superresolution.core.interop.memory.SharedMemory;
import io.homo.superresolution.core.vulkan.Utils;
import io.homo.superresolution.core.vulkan.texture.TextureUsage;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.opengl.EXTMemoryObject;
import org.lwjgl.opengl.EXTMemoryObjectFD;
import org.lwjgl.opengl.GL46;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.vulkan.KHRExternalMemoryFd;
import org.lwjgl.vulkan.VK11;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkExportMemoryAllocateInfo;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkExternalMemoryImageCreateInfo;
import org.lwjgl.vulkan.VkImageCreateInfo;
import org.lwjgl.vulkan.VkImageViewCreateInfo;
import org.lwjgl.vulkan.VkMemoryAllocateInfo;
import org.lwjgl.vulkan.VkMemoryGetFdInfoKHR;
import org.lwjgl.vulkan.VkMemoryRequirements;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkPhysicalDeviceMemoryProperties;

public class VkToGlTexture {
    private final VkDevice device;
    private final VkPhysicalDevice physicalDevice;
    private final int width;
    private final int height;
    private final TextureFormat format;
    private final TextureUsage usage;
    private final SharedMemory sharedMemory = new SharedMemory();
    private long vkImage = 0L;
    private long vkMemory = 0L;
    private long vkImageView = 0L;
    private int glTexture = 0;
    private int glMemoryObject = 0;

    public VkToGlTexture(VkDevice device, VkPhysicalDevice physicalDevice, int width, int height, TextureFormat format, TextureUsage usage) {
        this.device = device;
        this.physicalDevice = physicalDevice;
        this.width = width;
        this.height = height;
        this.format = format;
        this.usage = usage;
    }

    public void createVulkanResources() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkExternalMemoryImageCreateInfo extImgInfo = VkExternalMemoryImageCreateInfo.calloc((MemoryStack)stack).sType(1000072001).handleTypes(1);
            VkImageCreateInfo imageInfo = VkImageCreateInfo.calloc((MemoryStack)stack).sType(14).pNext(extImgInfo).imageType(1).format(this.format.vk()).extent(VkExtent3D.calloc((MemoryStack)stack).width(this.width).height(this.height).depth(1)).mipLevels(1).arrayLayers(1).samples(1).tiling(0).usage(this.usage.getValue() | 1).sharingMode(0).initialLayout(0);
            LongBuffer pImage = stack.mallocLong(1);
            Utils.VK_CHECK(VK11.vkCreateImage((VkDevice)this.device, (VkImageCreateInfo)imageInfo, null, (LongBuffer)pImage), "Failed to create Vulkan image");
            this.vkImage = pImage.get(0);
            VkMemoryRequirements memReqs = VkMemoryRequirements.malloc((MemoryStack)stack);
            VK11.vkGetImageMemoryRequirements((VkDevice)this.device, (long)this.vkImage, (VkMemoryRequirements)memReqs);
            VkExportMemoryAllocateInfo exportInfo = VkExportMemoryAllocateInfo.calloc((MemoryStack)stack).sType(1000072002).handleTypes(1);
            VkMemoryAllocateInfo allocInfo = VkMemoryAllocateInfo.calloc((MemoryStack)stack).sType(5).pNext(exportInfo).allocationSize(memReqs.size()).memoryTypeIndex(this.findMemoryType(memReqs.memoryTypeBits(), 1));
            LongBuffer pMemory = stack.mallocLong(1);
            Utils.VK_CHECK(VK11.vkAllocateMemory((VkDevice)this.device, (VkMemoryAllocateInfo)allocInfo, null, (LongBuffer)pMemory), "Failed to allocate Vulkan memory");
            this.vkMemory = pMemory.get(0);
            VK11.vkBindImageMemory((VkDevice)this.device, (long)this.vkImage, (long)this.vkMemory, (long)0L);
            VkMemoryGetFdInfoKHR getFdInfo = VkMemoryGetFdInfoKHR.calloc((MemoryStack)stack).sType(1000074002).memory(this.vkMemory).handleType(1);
            IntBuffer pFd = stack.mallocInt(1);
            KHRExternalMemoryFd.vkGetMemoryFdKHR((VkDevice)this.device, (VkMemoryGetFdInfoKHR)getFdInfo, (IntBuffer)pFd);
            this.sharedMemory.fd = pFd.get(0);
        }
    }

    public void createGLResources() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pMemObj = stack.mallocInt(1);
            EXTMemoryObject.glCreateMemoryObjectsEXT((IntBuffer)pMemObj);
            this.glMemoryObject = pMemObj.get(0);
            EXTMemoryObjectFD.glImportMemoryFdEXT((int)this.glMemoryObject, (long)this.getMemorySize(), (int)38278, (int)this.sharedMemory.fd);
            IntBuffer pTexture = stack.mallocInt(1);
            GL46.glGenTextures((IntBuffer)pTexture);
            this.glTexture = pTexture.get(0);
            GL46.glBindTexture((int)3553, (int)this.glTexture);
            EXTMemoryObject.glTexStorageMem2DEXT((int)3553, (int)1, (int)this.format.gl(), (int)this.width, (int)this.height, (int)this.glMemoryObject, (long)0L);
            this.setTextureParameters();
            GL46.glBindTexture((int)3553, (int)0);
        }
    }

    private void setTextureParameters() {
        GL46.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL46.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL46.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL46.glTexParameteri((int)3553, (int)10243, (int)33071);
    }

    public void createImageView() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkImageViewCreateInfo viewInfo = VkImageViewCreateInfo.calloc((MemoryStack)stack).sType(15).image(this.vkImage).viewType(1).format(this.format.vk()).subresourceRange(it -> it.aspectMask(1).baseMipLevel(0).levelCount(1).baseArrayLayer(0).layerCount(1));
            LongBuffer pView = stack.mallocLong(1);
            Utils.VK_CHECK(VK11.vkCreateImageView((VkDevice)this.device, (VkImageViewCreateInfo)viewInfo, null, (LongBuffer)pView), "Failed to create image view");
            this.vkImageView = pView.get(0);
        }
    }

    public void cleanup() {
        if (this.glTexture != 0) {
            GL46.glDeleteTextures((int)this.glTexture);
            this.glTexture = 0;
        }
        if (this.glMemoryObject != 0) {
            EXTMemoryObject.glDeleteMemoryObjectsEXT((int)this.glMemoryObject);
            this.glMemoryObject = 0;
        }
        if (this.vkImageView != 0L) {
            VK11.vkDestroyImageView((VkDevice)this.device, (long)this.vkImageView, null);
            this.vkImageView = 0L;
        }
        if (this.vkImage != 0L) {
            VK11.vkDestroyImage((VkDevice)this.device, (long)this.vkImage, null);
            this.vkImage = 0L;
        }
        if (this.vkMemory != 0L) {
            VK11.vkFreeMemory((VkDevice)this.device, (long)this.vkMemory, null);
            this.vkMemory = 0L;
        }
    }

    private int findMemoryType(int typeFilter, int properties) {
        VkPhysicalDeviceMemoryProperties memProps = VkPhysicalDeviceMemoryProperties.malloc();
        VK11.vkGetPhysicalDeviceMemoryProperties((VkPhysicalDevice)this.physicalDevice, (VkPhysicalDeviceMemoryProperties)memProps);
        for (int i = 0; i < memProps.memoryTypeCount(); ++i) {
            if ((typeFilter & 1 << i) == 0 || (memProps.memoryTypes(i).propertyFlags() & properties) != properties) continue;
            return i;
        }
        throw new RuntimeException("Failed to find suitable memory type!");
    }

    private long getMemorySize() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkMemoryRequirements memReqs = VkMemoryRequirements.malloc((MemoryStack)stack);
            VK11.vkGetImageMemoryRequirements((VkDevice)this.device, (long)this.vkImage, (VkMemoryRequirements)memReqs);
            long l = memReqs.size();
            return l;
        }
    }

    public long getVkImage() {
        return this.vkImage;
    }

    public int getGlTexture() {
        return this.glTexture;
    }

    public long getVkImageView() {
        return this.vkImageView;
    }
}

