/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.fabric.platform;

import io.homo.superresolution.common.platform.EnvType;
import io.homo.superresolution.common.platform.Platform;
import io.homo.superresolution.fabric.platform.IrisFabricPlatform;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class FabricPlatform
extends Platform {
    @Override
    public void init() {
        this.irisPlatform = new IrisFabricPlatform();
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public String getModVersionString(String modId) {
        if (this.isModLoaded(modId)) {
            return ((ModContainer)FabricLoader.getInstance().getModContainer(modId).orElseThrow()).getMetadata().getVersion().getFriendlyString();
        }
        return null;
    }

    @Override
    public EnvType getEnv() {
        return switch (FabricLoader.getInstance().getEnvironmentType()) {
            default -> throw new IncompatibleClassChangeError();
            case net.fabricmc.api.EnvType.CLIENT -> EnvType.CLIENT;
            case net.fabricmc.api.EnvType.SERVER -> EnvType.SERVER;
        };
    }

    @Override
    public Path getGameFolder() {
        return FabricLoader.getInstance().getGameDir().toAbsolutePath().normalize();
    }
}

