/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.fsr2.pipelines;

import io.homo.superresolution.core.gl.pipeline.GlPipelineJobBuilders;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceAccess;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceDescription;
import io.homo.superresolution.core.gl.shader.GlComputeShaderProgram;
import io.homo.superresolution.core.impl.Vec3;
import io.homo.superresolution.core.impl.shader.ShaderSource;
import io.homo.superresolution.fsr2.Fsr2Context;
import io.homo.superresolution.fsr2.Fsr2Dimensions;
import io.homo.superresolution.fsr2.Fsr2PipelineDispatchResource;
import io.homo.superresolution.fsr2.Fsr2PipelineResourceType;
import io.homo.superresolution.fsr2.Fsr2ShaderResource;
import io.homo.superresolution.fsr2.pipelines.Fsr2BasePipeline;

public class Fsr2ReconstructPreviousDepthPipeline
extends Fsr2BasePipeline {
    private GlComputeShaderProgram program;

    public Fsr2ReconstructPreviousDepthPipeline(Fsr2Context context) {
        super(context);
    }

    @Override
    public void resize(Fsr2Dimensions size) {
    }

    @Override
    public void destroy() {
        this.program.destroy();
    }

    @Override
    public void init() {
        this.program = ((GlComputeShaderProgram)GlComputeShaderProgram.create().addDefineText(this.getShaderDefines(null)).setShaderName("fsr2_reconstruct_previous_depth").addShaderSource(new ShaderSource(ShaderSource.Type.COMPUTE, "/shader/fsr2/ffx_fsr2_reconstruct_previous_depth_pass.ogl.glsl", true)).build()).compileShader();
    }

    @Override
    public void execute(Fsr2PipelineDispatchResource dispatchResource) {
        GlPipelineJobBuilders.ComputeJobBuilder jobBuilder = GlPipelineJobBuilders.compute(this.program).workGroupSupplier(() -> new Vec3(((float)this.context.dimensions.renderWidth() + 7.0f) / 8.0f, ((float)this.context.dimensions.renderHeight() + 7.0f) / 8.0f, 1.0f));
        jobBuilder.resource(GlPipelineResourceDescription.createUBOResource("cbFSR2", this.context.fsr2ConstantsUBO, 12));
        jobBuilder.resource(new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.INPUT_MOTION_VECTORS).binding(7).access(GlPipelineResourceAccess.READ).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.INPUT_DEPTH).binding(8).access(GlPipelineResourceAccess.READ).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.INPUT_COLOR).binding(9).access(GlPipelineResourceAccess.READ).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.INPUT_EXPOSURE).binding(10).access(GlPipelineResourceAccess.READ).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceTypeSupplier(() -> this.context.isOddFrame() ? Fsr2PipelineResourceType.LUMA_HISTORY_2 : Fsr2PipelineResourceType.LUMA_HISTORY_1).binding(11).access(GlPipelineResourceAccess.READ).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.RECONSTRUCTED_PREVIOUS_NEAREST_DEPTH).binding(0).access(GlPipelineResourceAccess.BOTH).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceTypeSupplier(() -> this.context.isOddFrame() ? Fsr2PipelineResourceType.INTERNAL_DILATED_MOTION_VECTORS_2 : Fsr2PipelineResourceType.INTERNAL_DILATED_MOTION_VECTORS_1).binding(1).access(GlPipelineResourceAccess.BOTH).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.DILATED_DEPTH).binding(2).access(GlPipelineResourceAccess.BOTH).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.PREPARED_INPUT_COLOR).binding(3).access(GlPipelineResourceAccess.BOTH).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceTypeSupplier(() -> this.context.isOddFrame() ? Fsr2PipelineResourceType.LUMA_HISTORY_1 : Fsr2PipelineResourceType.LUMA_HISTORY_2).binding(4).access(GlPipelineResourceAccess.BOTH).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.LOCK_INPUT_LUMA).binding(6).access(GlPipelineResourceAccess.BOTH).getResourceDescription(this.context));
        this.pipeline.addJob("fsr2_reconstruct_previous_depth", jobBuilder.build());
        this.pipeline.scheduleJobs();
        this.pipeline.executeJobs();
    }
}

