/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.fsr2.struct;

import io.homo.superresolution.core.impl.IUniformStruct;
import io.homo.superresolution.fsr2.Fsr2Context;
import io.homo.superresolution.fsr2.Fsr2Dimensions;
import io.homo.superresolution.fsr2.Fsr2DispatchDescription;
import io.homo.superresolution.fsr2.Fsr2Utils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.system.MemoryStack;

public class Fsr2CBSpd
implements IUniformStruct {
    private final ByteBuffer container;
    private final int[] workGroupOffset = new int[2];
    private final int[] renderSize = new int[2];
    private int numWorkGroups = 0;
    private int mips = 0;

    public Fsr2CBSpd() {
        this.container = MemoryStack.stackCalloc((int)this.sizeof());
        this.container.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void update(Fsr2Context context, Fsr2DispatchDescription desc, Fsr2Dimensions dims) {
        int[] dispatchThreadGroupCountXY = new int[2];
        int[] workGroupOffset = new int[2];
        int[] numWorkGroupsAndMips = new int[2];
        int[] rectInfo = new int[]{0, 0, (int)desc.renderSize().x, (int)desc.renderSize().y};
        Fsr2Utils.spdSetup(dispatchThreadGroupCountXY, workGroupOffset, numWorkGroupsAndMips, rectInfo);
        this.numWorkGroups = numWorkGroupsAndMips[0];
        this.mips = numWorkGroupsAndMips[1];
        System.arraycopy(workGroupOffset, 0, this.workGroupOffset, 0, 2);
        this.renderSize[0] = (int)desc.renderSize().x;
        this.renderSize[1] = (int)desc.renderSize().y;
        this.fillBuffer();
    }

    @Override
    public ByteBuffer container() {
        return this.container.duplicate().rewind();
    }

    @Override
    public int sizeof() {
        return 32;
    }

    public void fillBuffer() {
        this.container.clear();
        this.container.putInt(0, this.mips);
        this.container.putInt(4, this.numWorkGroups);
        this.container.putInt(8, this.workGroupOffset[0]);
        this.container.putInt(12, this.workGroupOffset[1]);
        this.container.putInt(16, this.renderSize[0]);
        this.container.putInt(20, this.renderSize[1]);
        for (int i = 24; i < 32; i += 4) {
            this.container.putInt(i, 0);
        }
        this.container.position(32);
        this.container.flip();
    }
}

