/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.api.config;

import com.electronwill.nightconfig.core.ConfigSpec;
import io.homo.superresolution.api.config.ConfigValue;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ListValue<E>
extends ConfigValue<List<E>> {
    private final Function<Object, E> elementConverter;
    protected final Predicate<E> elementValidator;

    public ListValue(List<String> path, Supplier<List<E>> defaultSupplier, String comment, Function<Object, E> elementConverter, Predicate<E> elementValidator) {
        super(path, defaultSupplier, comment);
        this.elementConverter = elementConverter;
        this.elementValidator = elementValidator;
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof List)) {
            return false;
        }
        List list = (List)value;
        for (Object element : list) {
            if (element == null) {
                return false;
            }
            try {
                E converted = this.elementConverter.apply(element);
                if (converted != null && this.elementValidator.test(converted)) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void fillSpec(ConfigSpec spec) {
        spec.defineList(this.path, ((Supplier)this.defaultSupplier)::get, obj -> this.elementValidator.test(obj));
    }

    @Override
    protected List<E> convertType(Object value) {
        if (value == null) {
            return (List)this.getDefault();
        }
        if (value instanceof List) {
            return ((List)value).stream().filter(e -> e != null).map(this.elementConverter).filter(this.elementValidator).collect(Collectors.toList());
        }
        return (List)this.getDefault();
    }
}

