/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.api.utils;

import io.homo.superresolution.api.platform.OperatingSystem;
import io.homo.superresolution.api.platform.OperatingSystemType;
import io.homo.superresolution.api.platform.Platform;
import io.homo.superresolution.api.platform.SystemArchitecture;
import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.GraphicsCapabilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class Requirement {
    private final Set<String> requiredGlExtensions = new HashSet<String>();
    private final Set<OperatingSystem> supportedOS = new HashSet<OperatingSystem>();
    private final Set<String> requiredVulkanDeviceExtensions = new HashSet<String>();
    private int glMajorVersion = -1;
    private int glMinorVersion = -1;
    private int vulkanMajorVersion = -1;
    private int vulkanMinorVersion = -1;
    private int vulkanPatchVersion = -1;
    private boolean requiresDevEnv = false;
    private boolean requiresVulkan = false;
    private final List<Supplier<Boolean>> additionalChecks = new ArrayList<Supplier<Boolean>>();

    private Requirement() {
    }

    public static Requirement nothing() {
        return new Requirement();
    }

    public Requirement vulkanMajorVersion(int vulkanMajorVersion) {
        this.vulkanMajorVersion = vulkanMajorVersion;
        return this;
    }

    public Requirement vulkanMinorVersion(int vulkanMinorVersion) {
        this.vulkanMinorVersion = vulkanMinorVersion;
        return this;
    }

    public Requirement vulkanPatchVersion(int vulkanPatchVersion) {
        this.vulkanPatchVersion = vulkanPatchVersion;
        return this;
    }

    public Requirement isTrue(Supplier<Boolean> dep) {
        this.additionalChecks.add(Objects.requireNonNull(dep, "dep\u4e0d\u80fd\u4e3anull"));
        return this;
    }

    public Requirement isFalse(Supplier<Boolean> dep) {
        this.additionalChecks.add(() -> (Boolean)Objects.requireNonNull(dep, "dep\u4e0d\u80fd\u4e3anull").get() == false);
        return this;
    }

    public Set<String> getRequiredGlExtensions() {
        return Collections.unmodifiableSet(this.requiredGlExtensions);
    }

    public Set<String> getRequiredVulkanDeviceExtensions() {
        return Collections.unmodifiableSet(this.requiredVulkanDeviceExtensions);
    }

    public boolean isRequiresVulkan() {
        return this.requiresVulkan;
    }

    public boolean isRequiresDevEnv() {
        return this.requiresDevEnv;
    }

    public int getGlMinorVersion() {
        return this.glMinorVersion;
    }

    public int getGlMajorVersion() {
        return this.glMajorVersion;
    }

    public int getVulkanMajorVersion() {
        return this.vulkanMajorVersion;
    }

    public int getVulkanMinorVersion() {
        return this.vulkanMinorVersion;
    }

    public int getVulkanPatchVersion() {
        return this.vulkanPatchVersion;
    }

    public Requirement developmentEnvironment(boolean developmentEnvironment) {
        this.requiresDevEnv = developmentEnvironment;
        return this;
    }

    public Requirement requireVulkan(boolean requireVulkan) {
        this.requiresVulkan = requireVulkan;
        return this;
    }

    public Requirement glVersion(int major, int minor) {
        this.glMajorVersion = major;
        this.glMinorVersion = minor;
        return this;
    }

    public Requirement vulkanVersion(int major, int minor, int patch) {
        this.vulkanMajorVersion = major;
        this.vulkanMinorVersion = minor;
        this.vulkanPatchVersion = patch;
        return this;
    }

    private boolean checkVulkanVersion() {
        if (this.vulkanMajorVersion == -1) {
            return true;
        }
        int[] current = GraphicsCapabilities.getVulkanVersion();
        return current[0] > this.vulkanMajorVersion || current[0] == this.vulkanMajorVersion && (current[1] > this.vulkanMinorVersion || current[1] == this.vulkanMinorVersion && current[2] >= this.vulkanPatchVersion);
    }

    private boolean checkVulkanDeviceExtensions() {
        return this.requiredVulkanDeviceExtensions.stream().allMatch(GraphicsCapabilities::hasVulkanDeviceExtension);
    }

    private boolean checkAdditionalConditions() {
        for (Supplier<Boolean> dep : this.additionalChecks) {
            try {
                if (dep.get().booleanValue()) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public Requirement requireVulkanDeviceExtension(String extension) {
        this.requiredVulkanDeviceExtensions.add(extension);
        return this;
    }

    public Requirement glMajorVersion(int major) {
        this.glMajorVersion = major;
        return this;
    }

    public Requirement glMinorVersion(int minor) {
        this.glMinorVersion = minor;
        return this;
    }

    public Requirement requiredGlExtension(String name) {
        this.requiredGlExtensions.add(Objects.requireNonNull(name, "\u6269\u5c55\u540d\u79f0\u4e0d\u80fd\u4e3anull"));
        return this;
    }

    public Result check() {
        if (System.getenv().containsKey("SR_TEST")) {
            return new Result(true, true, true, true, true, true, true, true);
        }
        return new Result(this.checkOSCompatibility(), this.checkGLVersion(), this.checkGLExtensions(), this.checkEnvironment(), this.checkVulkanSupport(), this.checkVulkanVersion(), this.checkVulkanDeviceExtensions(), this.checkAdditionalConditions());
    }

    private boolean checkOSCompatibility() {
        if (this.supportedOS.isEmpty()) {
            return true;
        }
        OperatingSystem current = Platform.currentPlatform.getOS();
        return this.supportedOS.stream().anyMatch(os -> os.arch.equals(current.arch) && os.type.equals(current.type));
    }

    private boolean checkGLVersion() {
        if (this.glMajorVersion == -1) {
            return true;
        }
        int[] currentVersion = GraphicsCapabilities.getGLVersion();
        return currentVersion[0] > this.glMajorVersion || currentVersion[0] == this.glMajorVersion && currentVersion[1] >= this.glMinorVersion;
    }

    private boolean checkGLExtensions() {
        return this.requiredGlExtensions.stream().allMatch(GraphicsCapabilities::hasGLExtension);
    }

    private boolean checkEnvironment() {
        return !this.requiresDevEnv || Platform.currentPlatform.isDevelopmentEnvironment();
    }

    private boolean checkVulkanSupport() {
        return !this.requiresVulkan || RenderSystems.isSupportVulkan();
    }

    public List<String> getMissingGlExtensions() {
        return this.requiredGlExtensions.stream().filter(ext -> !GraphicsCapabilities.hasGLExtension(ext)).toList();
    }

    public List<String> getMissingVkExtensions() {
        return this.requiredVulkanDeviceExtensions.stream().filter(ext -> !GraphicsCapabilities.hasVulkanDeviceExtension(ext)).toList();
    }

    public Set<OperatingSystem> getSupportedOS() {
        return Collections.unmodifiableSet(this.supportedOS);
    }

    public Requirement addSupportedOS(SystemArchitecture arch) {
        return this.addSupportedOS(new OperatingSystem(arch, OperatingSystemType.ANY));
    }

    public Requirement addSupportedOS(OperatingSystemType type) {
        return this.addSupportedOS(new OperatingSystem(SystemArchitecture.ANY, type));
    }

    public Requirement addSupportedOS(SystemArchitecture arch, OperatingSystemType type) {
        return this.addSupportedOS(new OperatingSystem(arch, type));
    }

    public Requirement addSupportedOS(OperatingSystem operatingSystem) {
        this.supportedOS.add(Objects.requireNonNull(operatingSystem, "\u64cd\u4f5c\u7cfb\u7edf\u914d\u7f6e\u4e0d\u80fd\u4e3anull"));
        return this;
    }

    @Deprecated
    public ArrayList<OperatingSystem> getIncludeOS() {
        return new ArrayList<OperatingSystem>(this.supportedOS);
    }

    public record Result(boolean osSupported, boolean glVersionMet, boolean glExtensionsPresent, boolean environmentValid, boolean vulkanAvailable, boolean vulkanVersionMet, boolean vulkanDeviceExtensionsMet, boolean additionalConditionsMet) {
        public boolean support() {
            return this.osSupported && this.glVersionMet && this.glExtensionsPresent && this.environmentValid && this.vulkanAvailable && this.vulkanVersionMet && this.vulkanDeviceExtensionsMet && this.additionalConditionsMet;
        }
    }
}

