/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.options;

import com.google.common.collect.ImmutableList;
import io.homo.superresolution.common.gui.impl.Text;
import io.homo.superresolution.common.gui.options.AbstractOptionBuilder;
import io.homo.superresolution.common.gui.options.SelectionListOptionEntry;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class SelectionListBuilder<T>
extends AbstractOptionBuilder<T, SelectionListOptionEntry<T>, SelectionListBuilder<T>> {
    protected ImmutableList<T> values;
    protected Function<T, String> nameProvider;

    public SelectionListBuilder(Text name, T value, T[] valuesArray) {
        super(name, value);
        this.values = ImmutableList.copyOf((Object[])valuesArray);
    }

    @Override
    public SelectionListOptionEntry<T> build() {
        SelectionListOptionEntry<Object> entry = new SelectionListOptionEntry<Object>(this.name, this.value, this.values);
        entry.setNameProvider(this.nameProvider);
        return this.finishBuild(entry);
    }

    public SelectionListBuilder<T> setValues(T[] valuesArray) {
        this.values = ImmutableList.copyOf((Object[])valuesArray);
        return this;
    }

    public SelectionListBuilder<T> setNameProvider(@Nullable Function<T, String> nameProvider) {
        this.nameProvider = nameProvider != null ? nameProvider : t -> t.toString();
        return this;
    }
}

