/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.screens;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.gui.ConfigScreenBuilder;
import io.homo.superresolution.common.gui.Rectangle;
import io.homo.superresolution.common.gui.ScissorsHandler;
import io.homo.superresolution.common.gui.widgets.ClothListWidget;
import io.homo.superresolution.core.utils.ColorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigScreen;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import me.shedaniel.clothconfig2.gui.entries.EmptyEntry;
import me.shedaniel.clothconfig2.gui.widget.SearchFieldEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClothStyleConfigScreen
extends AbstractConfigScreen {
    protected static final PanoramaRenderer panorama = new PanoramaRenderer(TitleScreen.f_96716_);
    protected final LinkedHashMap<Component, List<AbstractConfigEntry<?>>> categorizedEntries = Maps.newLinkedHashMap();
    public ClothListWidget listWidget;
    protected Button cancelButton;
    protected Button exitButton;
    protected Button saveButton;
    protected SearchFieldEntry searchFieldEntry;
    protected boolean enableSearch;
    protected double lastScroll = -1145.1145;

    public ClothStyleConfigScreen(Screen parent, Component title, Map<String, ConfigCategory> categoryMap, ResourceLocation backgroundLocation) {
        super(parent, title, backgroundLocation);
        categoryMap.forEach((categoryName, category) -> {
            ArrayList entries = Lists.newArrayList();
            for (Object object : category.getEntries()) {
                AbstractConfigListEntry entry = object instanceof Tuple ? (AbstractConfigListEntry)((Tuple)object).m_14419_() : (AbstractConfigListEntry)object;
                entry.setScreen((AbstractConfigScreen)this);
                entries.add(entry);
            }
            this.categorizedEntries.put(category.getCategoryKey(), entries);
        });
    }

    public void setEnableSearch(boolean enableSearch) {
        this.enableSearch = enableSearch;
    }

    public Map<Component, List<AbstractConfigEntry<?>>> getCategorizedEntries() {
        return this.categorizedEntries;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.listWidget = new ClothListWidget(this, this.f_96541_, this.f_96543_, this.f_96544_, 30, this.f_96544_ - 32, this.getBackgroundLocation());
        this.m_7787_((GuiEventListener)this.listWidget);
        if (this.enableSearch) {
            this.listWidget.m_6702_().add(new EmptyEntry(5));
            this.searchFieldEntry = new SearchFieldEntry((ConfigScreen)this, (ClothConfigScreen.ListWidget)this.listWidget);
            this.listWidget.m_6702_().add(this.searchFieldEntry);
            this.listWidget.m_6702_().add(new EmptyEntry(5));
        }
        this.categorizedEntries.forEach((category, entries) -> {
            if (!this.listWidget.m_6702_().isEmpty()) {
                this.listWidget.m_6702_().add(new EmptyEntry(5));
            }
            this.listWidget.m_6702_().add(new EmptyEntry(4));
            this.listWidget.m_6702_().add(new CategoryTextEntry((Component)category, (Component)category.m_6881_().m_130940_(ChatFormatting.BOLD)));
            this.listWidget.m_6702_().add(new EmptyEntry(4));
            this.listWidget.m_6702_().addAll(entries);
        });
        int buttonWidths = Math.min(200, (this.f_96543_ - 50 - 12) / 4);
        this.cancelButton = Button.m_253074_((Component)(this.isEdited() ? Component.m_237115_((String)"text.cloth-config.cancel_discard") : Component.m_237115_((String)"gui.cancel")), widget -> this.quit()).m_252987_(0, this.f_96544_ - 26, buttonWidths, 20).m_253136_();
        this.m_7787_((GuiEventListener)this.cancelButton);
        this.exitButton = new Button(0, this.f_96544_ - 26, buttonWidths, 20, (Component)Component.m_237119_(), button -> this.saveAll(true), Supplier::get){

            public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                boolean hasErrors = false;
                block0: for (List<AbstractConfigEntry<?>> entries : ClothStyleConfigScreen.this.categorizedEntries.values()) {
                    for (AbstractConfigEntry<?> entry : entries) {
                        if (!entry.getConfigError().isPresent()) continue;
                        hasErrors = true;
                        break block0;
                    }
                }
                this.f_93623_ = ClothStyleConfigScreen.this.isEdited() && !hasErrors;
                this.m_93666_((Component)(hasErrors ? Component.m_237115_((String)"text.cloth-config.error_cannot_save") : Component.m_237115_((String)"text.cloth-config.save_and_done")));
                super.m_87963_(graphics, mouseX, mouseY, delta);
            }
        };
        this.m_7787_((GuiEventListener)this.exitButton);
        this.saveButton = new Button(0, this.f_96544_ - 26, buttonWidths, 20, (Component)Component.m_237115_((String)"superresolution.screen.button.label.apply"), button -> {
            this.saveAll(false);
            double scroll = this.listWidget.getScroll();
            Minecraft.m_91087_().m_91152_(ConfigScreenBuilder.create().buildConfigScreen(this.parent));
            if (Minecraft.m_91087_().f_91080_ instanceof ClothStyleConfigScreen) {
                ((ClothStyleConfigScreen)Minecraft.m_91087_().f_91080_).lastScroll = scroll;
            }
        }, Supplier::get){

            public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                boolean hasErrors = false;
                block0: for (List<AbstractConfigEntry<?>> entries : ClothStyleConfigScreen.this.categorizedEntries.values()) {
                    for (AbstractConfigEntry<?> entry : entries) {
                        if (!entry.getConfigError().isPresent()) continue;
                        hasErrors = true;
                        break block0;
                    }
                }
                this.f_93623_ = ClothStyleConfigScreen.this.isEdited() && !hasErrors;
                this.m_93666_((Component)(hasErrors ? Component.m_237115_((String)"text.cloth-config.error_cannot_save") : Component.m_237115_((String)"superresolution.screen.button.label.apply")));
                super.m_87963_(graphics, mouseX, mouseY, delta);
            }
        };
        this.m_7787_((GuiEventListener)this.saveButton);
        Optional.ofNullable(this.afterInitConsumer).ifPresent(consumer -> consumer.accept(this));
    }

    public boolean matchesSearch(Iterator<String> tags) {
        if (this.searchFieldEntry == null) {
            return true;
        }
        return this.searchFieldEntry.matchesSearch(tags);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            panorama.m_110003_(Minecraft.m_91087_().m_91297_(), 1.0f);
        }
        graphics.m_280509_(0, 0, this.f_96543_, this.listWidget.top, ColorUtil.color(60, 0, 0, 0));
        graphics.m_280509_(0, this.listWidget.bottom, this.f_96543_, this.listWidget.height, ColorUtil.color(60, 0, 0, 0));
        if (this.lastScroll != -1145.1145) {
            this.listWidget.scrollTo(this.lastScroll, false);
            this.lastScroll = -1145.1145;
        }
        this.listWidget.width = this.f_96543_;
        this.listWidget.m_88315_(graphics, mouseX, mouseY, delta);
        this.saveButton.m_252865_(this.f_96543_ / 2 - this.saveButton.m_5711_() / 2);
        this.cancelButton.m_252865_(this.saveButton.m_252754_() - 3 - this.saveButton.m_5711_());
        this.exitButton.m_252865_(this.saveButton.m_252754_() + 3 + this.saveButton.m_5711_());
        this.cancelButton.m_88315_(graphics, mouseX, mouseY, delta);
        this.saveButton.m_88315_(graphics, mouseX, mouseY, delta);
        this.exitButton.m_88315_(graphics, mouseX, mouseY, delta);
        ScissorsHandler.scissor(new Rectangle(this.listWidget.left, this.listWidget.top, this.listWidget.width, this.listWidget.bottom - this.listWidget.top));
        for (AbstractConfigEntry child : this.listWidget.m_6702_()) {
            child.lateRender(graphics, mouseX, mouseY, delta);
        }
        ScissorsHandler.removeLastScissor();
        graphics.m_280648_(this.f_96547_, this.f_96539_.m_7532_(), (int)((float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2.0f), 12, -1);
        super.m_88315_(graphics, mouseX, mouseY, delta);
    }

    public void m_280273_(@NotNull GuiGraphics guiGraphics) {
    }

    public boolean m_7043_() {
        return SuperResolutionConfig.isPauseGameOnGui();
    }

    protected static class CategoryTextEntry
    extends AbstractConfigListEntry<Object> {
        private final Component category;
        private final Component text;

        public CategoryTextEntry(Component category, Component text) {
            super((Component)Component.m_237113_((String)UUID.randomUUID().toString()), false);
            this.category = category;
            this.text = text;
        }

        public int getItemHeight() {
            List strings = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)this.text, this.getParent().getItemWidth());
            if (strings.isEmpty()) {
                return 0;
            }
            return 4 + strings.size() * 10;
        }

        @Nullable
        public ComponentPath m_264064_(FocusNavigationEvent focusNavigationEvent) {
            return null;
        }

        public Object getValue() {
            return null;
        }

        public Optional<Object> getDefaultValue() {
            return Optional.empty();
        }

        public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
            return false;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
            int yy = y + 2;
            List texts = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)this.text, this.getParent().getItemWidth());
            for (FormattedCharSequence text : texts) {
                graphics.m_280648_(Minecraft.m_91087_().f_91062_, text, x - 4 + entryWidth / 2 - Minecraft.m_91087_().f_91062_.m_92724_(text) / 2, yy, -1);
                yy += 10;
            }
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }

        public Component getCategory() {
            return this.category;
        }
    }
}

