/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft.handler;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import io.homo.superresolution.api.event.AlgorithmDispatchEvent;
import io.homo.superresolution.api.event.AlgorithmDispatchFinishEvent;
import io.homo.superresolution.api.platform.Platform;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.config.enums.CaptureMode;
import io.homo.superresolution.common.minecraft.CallType;
import io.homo.superresolution.common.minecraft.LegacyStorageFrameBuffer;
import io.homo.superresolution.common.minecraft.MinecraftRenderTargetType;
import io.homo.superresolution.common.minecraft.handler.IMinecraftRenderHandler;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.common.mixin.core.accessor.PostChainAccessor;
import io.homo.superresolution.common.perf.PerformanceRecoder;
import io.homo.superresolution.common.upscale.AlgorithmManager;
import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.common.upscale.MotionVectorsGenerator;
import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.CopyOperation;
import io.homo.superresolution.core.graphics.impl.buffer.BufferDescription;
import io.homo.superresolution.core.graphics.impl.buffer.BufferUsage;
import io.homo.superresolution.core.graphics.impl.buffer.IBuffer;
import io.homo.superresolution.core.graphics.impl.buffer.IBufferData;
import io.homo.superresolution.core.graphics.impl.buffer.UniformStructBuilder;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.graphics.impl.framebuffer.IBindableFrameBuffer;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.pipeline.Pipeline;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineJobBuilders;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineJobResource;
import io.homo.superresolution.core.graphics.impl.shader.IShaderProgram;
import io.homo.superresolution.core.graphics.impl.shader.ShaderDescription;
import io.homo.superresolution.core.graphics.impl.shader.ShaderSource;
import io.homo.superresolution.core.graphics.impl.shader.ShaderType;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.impl.texture.TextureWrapMode;
import io.homo.superresolution.core.graphics.opengl.Gl;
import io.homo.superresolution.core.graphics.opengl.GlDebug;
import io.homo.superresolution.core.graphics.opengl.GlState;
import io.homo.superresolution.core.graphics.opengl.GlStates;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.graphics.opengl.texture.GlTexture2D;
import io.homo.superresolution.core.graphics.opengl.utils.GlTextureCopier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import org.lwjgl.opengl.GL11;

public class MinecraftRenderHandler
implements IMinecraftRenderHandler {
    private final Map<MinecraftRenderTargetType, IBindableFrameBuffer> renderTargets = new HashMap<MinecraftRenderTargetType, IBindableFrameBuffer>();
    public ITexture colorTexture;
    public ITexture depthTexture;
    private IFrameBuffer preprocessDepthFrameBuffer;
    private Pipeline depthPreprocessPipeline;
    private IShaderProgram<?> depthPreprocessShader;
    private IBufferData depthPreprocessConfigData;
    private IBuffer depthPreprocessConfigUBO;
    private IBindableFrameBuffer renderTarget;

    @Override
    public void initialize() {
        RenderSystem.assertOnRenderThread();
        this.renderTarget = new LegacyStorageFrameBuffer(true);
        this.renderTarget.label("SRMainRenderTarget");
        this.renderTarget.setClearColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
        this.renderTarget.resizeFrameBuffer(RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight());
        this.colorTexture = RenderSystems.current().device().createTexture(TextureDescription.create().label("SRMainColorTexture").format(SuperResolutionConfig.getInternalTextureFormat()).type(TextureType.Texture2D).usages(TextureUsages.create().storage().sampler()).mipmapsDisabled().wrapMode(TextureWrapMode.ClampToEdge).size(RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight()).build());
        this.depthTexture = RenderSystems.current().device().createTexture(TextureDescription.create().label("SRMainDepthTexture").mipmapsDisabled().format(TextureFormat.R32F).usages(TextureUsages.create().storage().sampler()).type(TextureType.Texture2D).wrapMode(TextureWrapMode.ClampToEdge).size(RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight()).build());
        this.preprocessDepthFrameBuffer = GlFrameBuffer.create(this.depthTexture, null);
        this.depthPreprocessConfigData = UniformStructBuilder.start().floatEntry("near").floatEntry("far").build();
        this.depthPreprocessConfigUBO = RenderSystems.current().device().createBuffer(BufferDescription.create().size(this.depthPreprocessConfigData.size()).usage(BufferUsage.Ubo).build());
        this.depthPreprocessConfigUBO.setBufferData(this.depthPreprocessConfigData);
        this.depthPreprocessShader = RenderSystems.current().device().createShaderProgram(ShaderDescription.graphics(new ShaderSource(ShaderType.Fragment, "/shader/preprocess_depth.frag.glsl", true), new ShaderSource(ShaderType.Vertex, "/shader/preprocess_depth.vert.glsl", true)).name("SRPreprocessDepthShader").uniformBuffer("camera_config", 0, (int)this.depthPreprocessConfigData.size()).uniformSamplerTexture("tex", 0).build());
        this.depthPreprocessShader.compile();
        this.depthPreprocessPipeline = new Pipeline();
        this.depthPreprocessPipeline.job("preprocessDepth", ((PipelineJobBuilders.GraphicsJobBuilder)((PipelineJobBuilders.GraphicsJobBuilder)PipelineJobBuilders.graphics(this.depthPreprocessShader).targetFramebuffer(this.preprocessDepthFrameBuffer).resource("tex", PipelineJobResource.SamplerTexture.create(this.renderTarget.getTexture(FrameBufferAttachmentType.AnyDepth)))).resource("camera_config", PipelineJobResource.UniformBuffer.create(this.depthPreprocessConfigUBO))).build());
    }

    @Override
    public void onProcessPostChain(PostChain postChain) {
        int renderWidth = RenderHandlerManager.getRenderWidth();
        int renderHeight = RenderHandlerManager.getRenderHeight();
        for (RenderTarget renderTarget : ((PostChainAccessor)postChain).getFullSizedTargets()) {
            if (renderTarget.f_83915_ == renderWidth && renderTarget.f_83916_ == renderHeight && ((PostChainAccessor)postChain).getScreenWidth() == renderWidth && ((PostChainAccessor)postChain).getScreenHeight() == renderHeight) continue;
            postChain.m_110025_(renderWidth, renderHeight);
            break;
        }
    }

    public void updateRenderTarget() {
        this.renderTargets.clear();
        for (MinecraftRenderTargetType minecraftRenderTargetType : MinecraftRenderTargetType.values()) {
            IBindableFrameBuffer renderTarget = minecraftRenderTargetType.get(Minecraft.m_91087_().f_91060_);
            if (renderTarget == null) continue;
            this.renderTargets.put(minecraftRenderTargetType, renderTarget);
        }
    }

    public IBindableFrameBuffer getRenderTarget(MinecraftRenderTargetType type) {
        return this.renderTargets.get((Object)type);
    }

    @Override
    public void resize() {
        int screenWidth = RenderHandlerManager.getScreenWidth();
        int screenHeight = RenderHandlerManager.getScreenHeight();
        int renderWidth = RenderHandlerManager.getRenderWidth();
        int renderHeight = RenderHandlerManager.getRenderHeight();
        this.callOnRenderTargets(renderTarget -> this.resizeRenderTarget((IFrameBuffer)renderTarget, renderWidth, renderHeight), false);
    }

    private void resizeRenderTarget(IFrameBuffer renderTarget, int width, int height) {
        renderTarget.resizeFrameBuffer(width, height);
    }

    private boolean checkRenderWorldCallPos(CallType type) {
        return switch (SuperResolutionConfig.getCaptureMode()) {
            default -> throw new IncompatibleClassChangeError();
            case CaptureMode.A, CaptureMode.C -> {
                if (type == CallType.GAME_RENDERER) {
                    yield true;
                }
                yield false;
            }
            case CaptureMode.B -> type == CallType.LEVEL_RENDERER;
        };
    }

    private boolean checkRenderHandCallPos() {
        boolean bl;
        block4: {
            switch (SuperResolutionConfig.getCaptureMode()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case A: 
                case B: {
                    break;
                }
                case C: {
                    if (Platform.currentPlatform.iris().isShaderPackInUse()) break;
                    bl = true;
                    break block4;
                }
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public void onRenderWorldBegin(CallType type) {
        if (!this.checkRenderWorldCallPos(type)) {
            return;
        }
        this.updateRenderTarget();
        this.updateRenderTargetSize();
        if (SuperResolutionConfig.isEnableUpscale()) {
            RenderHandlerManager.setClientRenderTarget(this.renderTarget.asMcRenderTarget());
            this.renderTarget.bind(FrameBufferBindPoint.Write);
        }
    }

    @Override
    public void onRenderWorldEnd(CallType type) {
        if (!this.checkRenderWorldCallPos(type)) {
            return;
        }
        if (SuperResolutionConfig.isEnableUpscale()) {
            RenderHandlerManager.setClientRenderTarget(RenderHandlerManager.getOriginRenderTarget().asMcRenderTarget());
        }
        RenderHandlerManager.getOriginRenderTarget().bind(FrameBufferBindPoint.Write, true);
        GlDebug.pushGroup(64108435, "SRUpscale");
        PerformanceRecoder.beginUpscale();
        try (GlState ignored = new GlState();){
            AlgorithmManager.update();
            if (SuperResolutionConfig.isEnableUpscale()) {
                DispatchResource dispatchResource;
                GlTextureCopier.copy(CopyOperation.create().src(this.renderTarget.getTexture(FrameBufferAttachmentType.Color)).dst(this.colorTexture).fromTo(CopyOperation.TextureChancel.R, CopyOperation.TextureChancel.R).fromTo(CopyOperation.TextureChancel.G, CopyOperation.TextureChancel.G).fromTo(CopyOperation.TextureChancel.B, CopyOperation.TextureChancel.B));
                GlTextureCopier.copy(CopyOperation.create().src(this.renderTarget.getTexture(FrameBufferAttachmentType.AnyDepth)).dst(this.depthTexture).fromTo(CopyOperation.TextureChancel.R, CopyOperation.TextureChancel.R));
                if (SuperResolutionConfig.isGenerateMotionVectors()) {
                    MotionVectorsGenerator.update(this.colorTexture, this.renderTarget.getTexture(FrameBufferAttachmentType.AnyDepth));
                    dispatchResource = AlgorithmManager.getDispatchResource(this.colorTexture, this.depthTexture, AlgorithmManager.getMotionVectorsFrameBuffer().getTexture(FrameBufferAttachmentType.Color));
                } else {
                    dispatchResource = AlgorithmManager.getDispatchResource(this.colorTexture, this.depthTexture, null);
                }
                if (SuperResolution.currentAlgorithm != null && AlgorithmDispatchEvent.EVENT.hasEvent()) {
                    AlgorithmDispatchEvent.EVENT.invoker().onAlgorithmDispatch(SuperResolution.currentAlgorithm, dispatchResource);
                }
                SuperResolution.getCurrentAlgorithm().dispatch(dispatchResource);
                if (SuperResolution.currentAlgorithm != null && AlgorithmDispatchFinishEvent.EVENT.hasEvent()) {
                    AlgorithmDispatchFinishEvent.EVENT.invoker().onAlgorithmDispatchFinish(SuperResolution.currentAlgorithm, SuperResolution.currentAlgorithm.getOutputFrameBuffer().getTexture(FrameBufferAttachmentType.Color));
                }
                IFrameBuffer outFbo = SuperResolution.getCurrentAlgorithm().getOutputFrameBuffer();
                Gl.DSA.blitFramebuffer((int)outFbo.handle(), (int)RenderHandlerManager.getOriginRenderTarget().handle(), 0, 0, outFbo.getWidth(), outFbo.getHeight(), 0, 0, RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight(), 16384, 9728);
                if (SuperResolutionConfig.getCaptureMode() == CaptureMode.C && !Platform.currentPlatform.iris().isShaderPackInUse()) {
                    this.blitHandRenderTarget();
                }
            }
        }
        GL11.glViewport((int)0, (int)0, (int)RenderHandlerManager.getScreenWidth(), (int)RenderHandlerManager.getScreenHeight());
        PerformanceRecoder.endUpscale();
        GlDebug.popGroup();
        RenderHandlerManager.getOriginRenderTarget().bind(FrameBufferBindPoint.Write);
    }

    public void callOnRenderTargets(Consumer<IFrameBuffer> callback) {
        this.renderTargets.forEach((minecraftRenderTargetType, renderTarget) -> {
            if (renderTarget != null && minecraftRenderTargetType != MinecraftRenderTargetType.HAND) {
                callback.accept((IFrameBuffer)renderTarget);
            }
        });
    }

    public void callOnRenderTargets(BiConsumer<IFrameBuffer, MinecraftRenderTargetType> callback) {
        this.renderTargets.forEach((minecraftRenderTargetType, renderTarget) -> {
            if (renderTarget != null) {
                callback.accept((IFrameBuffer)renderTarget, (MinecraftRenderTargetType)((Object)minecraftRenderTargetType));
            }
        });
    }

    public void callOnRenderTarget(MinecraftRenderTargetType type, Consumer<IFrameBuffer> callback) {
        if (this.getRenderTarget(type) != null) {
            callback.accept(this.getRenderTarget(type));
        }
    }

    public void callOnRenderTarget(Consumer<IFrameBuffer> callback) {
        if (this.renderTarget != null) {
            callback.accept(this.renderTarget);
        }
    }

    public void callOnRenderTargets(Consumer<IFrameBuffer> callback, boolean includeMainRenderTarget) {
        this.callOnRenderTargets(callback);
        if (includeMainRenderTarget && this.renderTarget != null) {
            callback.accept(this.renderTarget);
        }
    }

    public void updateRenderTargetSize() {
        int renderWidth = RenderHandlerManager.getRenderWidth();
        int renderHeight = RenderHandlerManager.getRenderHeight();
        int screenWidth = RenderHandlerManager.getScreenWidth();
        int screenHeight = RenderHandlerManager.getScreenHeight();
        this.callOnRenderTargets(renderTarget -> {
            if (renderTarget.getWidth() != renderWidth || renderTarget.getHeight() != renderHeight) {
                renderTarget.resizeFrameBuffer(renderWidth, renderHeight);
            }
        }, true);
        IBindableFrameBuffer handRenderTarget = this.getRenderTarget(MinecraftRenderTargetType.HAND);
        if (handRenderTarget.getWidth() != screenWidth || handRenderTarget.getHeight() != screenHeight) {
            handRenderTarget.resizeFrameBuffer(screenWidth, screenHeight);
        }
        if (this.colorTexture.getWidth() != renderWidth || this.colorTexture.getHeight() != renderHeight) {
            this.colorTexture.resize(renderWidth, renderHeight);
        }
        if (this.depthTexture.getWidth() != renderWidth || this.depthTexture.getHeight() != renderHeight) {
            this.depthTexture.resize(renderWidth, renderHeight);
        }
        if (this.preprocessDepthFrameBuffer.getWidth() != renderWidth || this.preprocessDepthFrameBuffer.getHeight() != renderHeight) {
            this.preprocessDepthFrameBuffer.resizeFrameBuffer(renderWidth, renderHeight);
        }
    }

    @Override
    public void onRenderHandBegin() {
        if (!this.checkRenderHandCallPos()) {
            return;
        }
        GlStates.save("hand");
        RenderHandlerManager.setClientRenderTarget(this.getRenderTarget(MinecraftRenderTargetType.HAND).asMcRenderTarget());
        this.getRenderTarget(MinecraftRenderTargetType.HAND).clearFrameBuffer();
        this.getRenderTarget(MinecraftRenderTargetType.HAND).bind(FrameBufferBindPoint.All);
    }

    public void blitHandRenderTarget() {
        GL11.glEnable((int)3042);
        this.callOnRenderTarget(MinecraftRenderTargetType.HAND, renderTarget -> GlTexture2D.blitToScreen(RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight(), RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight(), renderTarget.getTexture(FrameBufferAttachmentType.Color)));
        GL11.glDisable((int)3042);
    }

    @Override
    public void onRenderHandEnd() {
        if (!this.checkRenderHandCallPos()) {
            return;
        }
        RenderHandlerManager.setClientRenderTarget(this.renderTarget.asMcRenderTarget());
        GlStates.pop("hand").restore();
    }

    @Override
    public IBindableFrameBuffer getFullSizeRenderTarget() {
        return RenderHandlerManager.getOriginRenderTarget();
    }

    @Override
    public IBindableFrameBuffer getScaledRenderTarget() {
        return this.renderTarget;
    }

    @Override
    public void destroy() {
        this.colorTexture.destroy();
        this.depthTexture.destroy();
        this.depthPreprocessConfigUBO.destroy();
        this.depthPreprocessShader.destroy();
        this.depthPreprocessConfigData.free();
        this.depthPreprocessPipeline.destroy();
        this.preprocessDepthFrameBuffer.destroy();
        this.renderTarget.destroy();
    }

    @Override
    public ITexture getColorTexture() {
        return this.colorTexture;
    }

    @Override
    public ITexture getDepthTexture() {
        return this.depthTexture;
    }
}

