/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.upscale;

import io.homo.superresolution.api.InputResourceSet;
import io.homo.superresolution.api.SuperResolutionAPI;
import io.homo.superresolution.api.registry.AlgorithmDescription;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.common.perf.PerformanceRecoder;
import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.common.upscale.MotionVectorsGenerator;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;

public class AlgorithmManager {
    public static AlgorithmParam param = new AlgorithmParam();

    public static GlFrameBuffer getMotionVectorsFrameBuffer() {
        return (GlFrameBuffer)MotionVectorsGenerator.getMotionVectorsFrameBuffer();
    }

    public static void destroy() {
    }

    public static void resize(int width, int height) {
        MotionVectorsGenerator.resize();
    }

    public static boolean isSupportAlgorithm(AlgorithmDescription<?> type) {
        return type.getRequirement().check().support();
    }

    public static float extractVerticalFovDegrees(Matrix4f projectionMatrix) {
        float m11 = projectionMatrix.m11();
        float halfFovRad = (float)Math.atan(1.0f / m11);
        float fovDegrees = (float)Math.toDegrees(halfFovRad * 2.0f);
        return fovDegrees;
    }

    public static void setMatrixVanilla(Matrix4f proj, Matrix4f modelView) {
        AlgorithmManager.setModelViewMatrix(modelView);
        AlgorithmManager.setProjectionMatrix(proj);
        AlgorithmManager.param.verticalFov = AlgorithmManager.extractVerticalFovDegrees(proj);
        Matrix4f curViewProjectionMatrix = new Matrix4f((Matrix4fc)proj);
        curViewProjectionMatrix.mul((Matrix4fc)modelView);
        AlgorithmManager.param.lastModelViewProjectionMatrix = AlgorithmManager.param.lastModelViewProjectionMatrix == null ? curViewProjectionMatrix : AlgorithmManager.param.currentModelViewProjectionMatrix;
        AlgorithmManager.param.currentModelViewProjectionMatrix = curViewProjectionMatrix;
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Matrix4f viewMatrix = new Matrix4f().lookAt((float)camera.m_90583_().f_82479_, (float)camera.m_90583_().f_82480_, (float)camera.m_90583_().f_82481_, (float)(camera.m_90583_().f_82479_ + (double)camera.m_253058_().x), (float)(camera.m_90583_().f_82480_ + (double)camera.m_253058_().y), (float)(camera.m_90583_().f_82481_ + (double)camera.m_253058_().z), camera.m_253028_().x, camera.m_253028_().y, camera.m_253028_().z);
        AlgorithmManager.param.lastViewMatrix = AlgorithmManager.param.lastViewMatrix == null ? viewMatrix : AlgorithmManager.param.currentViewMatrix;
        AlgorithmManager.param.currentViewMatrix = viewMatrix;
    }

    private static void setProjectionMatrix(Matrix4f cur) {
        AlgorithmManager.param.lastProjectionMatrix = AlgorithmManager.param.lastProjectionMatrix == null ? new Matrix4f((Matrix4fc)cur) : AlgorithmManager.param.currentProjectionMatrix;
        AlgorithmManager.param.currentProjectionMatrix = new Matrix4f((Matrix4fc)cur);
    }

    private static void setModelViewMatrix(Matrix4f cur) {
        AlgorithmManager.param.lastModelViewMatrix = AlgorithmManager.param.lastModelViewMatrix == null ? new Matrix4f((Matrix4fc)cur) : AlgorithmManager.param.currentModelViewMatrix;
        AlgorithmManager.param.currentModelViewMatrix = new Matrix4f((Matrix4fc)cur);
    }

    public static Vector2f getJitterOffset() {
        if (SuperResolutionAPI.getCurrentAlgorithm() != null) {
            Vector2f jitter = SuperResolutionAPI.getCurrentAlgorithm().getJitterOffset(RenderHandlerManager.getFrameCount(), new Vector2f((float)RenderHandlerManager.getRenderWidth(), (float)RenderHandlerManager.getRenderHeight()), new Vector2f((float)RenderHandlerManager.getScreenWidth(), (float)RenderHandlerManager.getScreenHeight()));
            return jitter;
        }
        return new Vector2f(0.0f);
    }

    public static Matrix4f applyJitterOffset(Matrix4f proj, Vector2f jitter) {
        float jx_ndc = 2.0f * jitter.x / (float)RenderHandlerManager.getRenderWidth();
        float jy_ndc = 2.0f * jitter.y / (float)RenderHandlerManager.getRenderHeight();
        proj.m20(proj.m20() + jx_ndc);
        proj.m21(proj.m21() + jy_ndc);
        return proj;
    }

    public static DispatchResource getDispatchResource(ITexture color, ITexture depth, ITexture motionVectors) {
        return new DispatchResource(RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight(), new Vector2f((float)RenderHandlerManager.getRenderWidth(), (float)RenderHandlerManager.getRenderHeight()), RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight(), new Vector2f((float)RenderHandlerManager.getScreenWidth(), (float)RenderHandlerManager.getScreenHeight()), RenderHandlerManager.getFrameCount(), PerformanceRecoder.getCpuFrameTimeMs(), (float)AlgorithmManager.param.verticalFov, (float)Math.tan(AlgorithmManager.param.verticalFov / 2.0) * (float)RenderHandlerManager.getRenderWidth() / (float)RenderHandlerManager.getRenderHeight(), 0.05f, Minecraft.m_91087_().f_91063_.m_172790_(), AlgorithmManager.param.currentModelViewMatrix, AlgorithmManager.param.currentProjectionMatrix, AlgorithmManager.param.currentModelViewProjectionMatrix, AlgorithmManager.param.currentViewMatrix, AlgorithmManager.param.lastModelViewMatrix, AlgorithmManager.param.lastProjectionMatrix, AlgorithmManager.param.lastModelViewProjectionMatrix, AlgorithmManager.param.lastViewMatrix, new InputResourceSet(color, depth, (ITexture)(motionVectors == null ? (AlgorithmManager.getMotionVectorsFrameBuffer() == null ? null : AlgorithmManager.getMotionVectorsFrameBuffer().getTexture(FrameBufferAttachmentType.Color)) : motionVectors)));
    }

    public static void init() {
        MotionVectorsGenerator.init();
    }

    public static void update() {
    }

    public static class AlgorithmParam {
        public Matrix4f lastProjectionMatrix;
        public Matrix4f currentProjectionMatrix;
        public Matrix4f currentModelViewMatrix;
        public Matrix4f lastModelViewMatrix;
        public Matrix4f currentModelViewProjectionMatrix;
        public Matrix4f lastModelViewProjectionMatrix;
        public Matrix4f currentViewMatrix;
        public Matrix4f lastViewMatrix;
        public double verticalFov = 11.4514f;
    }
}

