/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.upscale.fsr1;

import io.homo.superresolution.api.AbstractAlgorithm;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.GraphicsCapabilities;
import io.homo.superresolution.core.graphics.impl.buffer.BufferDescription;
import io.homo.superresolution.core.graphics.impl.buffer.BufferUsage;
import io.homo.superresolution.core.graphics.impl.buffer.IBuffer;
import io.homo.superresolution.core.graphics.impl.buffer.StructuredUniformBuffer;
import io.homo.superresolution.core.graphics.impl.buffer.UniformStructBuilder;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.pipeline.Pipeline;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineComputeJob;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineJobBuilders;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineJobResource;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineResourceAccess;
import io.homo.superresolution.core.graphics.impl.shader.IShaderProgram;
import io.homo.superresolution.core.graphics.impl.shader.ShaderDescription;
import io.homo.superresolution.core.graphics.impl.shader.ShaderSource;
import io.homo.superresolution.core.graphics.impl.shader.ShaderType;
import io.homo.superresolution.core.graphics.impl.shader.uniform.ShaderUniformAccess;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.graphics.opengl.shader.GlShaderProgram;
import java.util.Optional;
import org.joml.Vector3i;

public class FSR1
extends AbstractAlgorithm {
    private IShaderProgram<?> fsr1EASUShader;
    private IShaderProgram<?> fsr1RCASShader;
    private Pipeline fsrUpscalePipeline;
    private ITexture fsr1TempTexture;
    private IFrameBuffer outputFbo;
    private ITexture output;
    private StructuredUniformBuffer fsr1UBOData;
    private IBuffer fsr1UBO;

    @Override
    public void init() {
        this.fsr1UBOData = UniformStructBuilder.start().vec2Entry("renderViewportSize").vec2Entry("containerTextureSize").vec2Entry("upscaledViewportSize").floatEntry("sharpness").build();
        this.fsr1UBO = RenderSystems.current().device().createBuffer(BufferDescription.create().size(this.fsr1UBOData.size()).usage(BufferUsage.Ubo).build());
        this.fsr1UBO.setBufferData(this.fsr1UBOData);
        this.initShader();
        this.fsrUpscalePipeline = new Pipeline();
        this.fsr1TempTexture = RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).width(RenderHandlerManager.getRenderWidth()).height(RenderHandlerManager.getRenderHeight()).format(SuperResolutionConfig.getInternalTextureFormat()).usages(TextureUsages.create().sampler().storage()).label("Fsr1TempTexture").build());
        this.output = RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).width(RenderHandlerManager.getScreenWidth()).height(RenderHandlerManager.getScreenHeight()).format(SuperResolutionConfig.getInternalTextureFormat()).usages(TextureUsages.create().sampler().storage()).label("Fsr1OutputTexture").build());
        this.outputFbo = GlFrameBuffer.create(this.output, null, RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight());
        this.outputFbo.label("Fsr1OutputFbo");
        this.fsrUpscalePipeline.job("fsr1_easu", ((PipelineJobBuilders.ComputeJobBuilder)((PipelineJobBuilders.ComputeJobBuilder)((PipelineJobBuilders.ComputeJobBuilder)PipelineJobBuilders.compute(this.fsr1EASUShader).resource("inImage", PipelineJobResource.SamplerTexture.create(() -> Optional.ofNullable(this.getResources().colorTexture())))).resource("outImage", PipelineJobResource.StorageTexture.create(this.fsr1TempTexture, PipelineResourceAccess.Write))).resource("fsr1_data", PipelineJobResource.UniformBuffer.create(this.fsr1UBO))).workGroupSupplier(this::getWorkGroupSize).build());
        this.fsrUpscalePipeline.job("fsr1_rcas", ((PipelineJobBuilders.ComputeJobBuilder)((PipelineJobBuilders.ComputeJobBuilder)((PipelineJobBuilders.ComputeJobBuilder)PipelineJobBuilders.compute(this.fsr1RCASShader).resource("inImage", PipelineJobResource.StorageTexture.create(this.fsr1TempTexture, PipelineResourceAccess.Read))).resource("outImage", PipelineJobResource.StorageTexture.create(this.output, PipelineResourceAccess.Write))).resource("fsr1_data", PipelineJobResource.UniformBuffer.create(this.fsr1UBO))).workGroupSupplier(this::getWorkGroupSize).build());
        this.resize(RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight());
    }

    public void initShader() {
        int fp16 = (Boolean)SuperResolutionConfig.SPECIAL.FSR1.FP16.get() != false ? FSR1.checkFP16Support() : 0;
        this.fsr1EASUShader = RenderSystems.current().device().createShaderProgram(ShaderDescription.compute(ShaderSource.file(ShaderType.Compute, "/shader/fsr1/fsr1_main.comp.glsl")).name("FSR1_EASU").addDefine("FSR_FP16_CRITERIA", String.valueOf(fp16)).addDefine("FSR_HALF", String.valueOf(fp16 == 0 ? 0 : 1)).addDefine("FSR_EASU", String.valueOf(1)).addDefine("SR_INTERNAL_TEXTURE_FORMAT", SuperResolutionConfig.getInternalTextureFormatGlslFormatQualifier()).uniformBuffer("fsr1_data", 0, (int)this.fsr1UBOData.size()).uniformSamplerTexture("inImage", 0).uniformStorageTexture("outImage", ShaderUniformAccess.Write, 1).build());
        this.fsr1RCASShader = RenderSystems.current().device().createShaderProgram(ShaderDescription.compute(ShaderSource.file(ShaderType.Compute, "/shader/fsr1/fsr1_main.comp.glsl")).name("FSR1_RCAS").addDefine("FSR_FP16_CRITERIA", String.valueOf(fp16)).addDefine("FSR_HALF", String.valueOf(fp16 == 0 ? 0 : 1)).addDefine("FSR_RCAS", String.valueOf(1)).addDefine("SR_INTERNAL_TEXTURE_FORMAT", SuperResolutionConfig.getInternalTextureFormatGlslFormatQualifier()).uniformBuffer("fsr1_data", 0, (int)this.fsr1UBOData.size()).uniformStorageTexture("inImage", ShaderUniformAccess.Read, 0).uniformStorageTexture("outImage", ShaderUniformAccess.Write, 1).build());
        if (fp16 == 2) {
            if (this.fsr1EASUShader instanceof GlShaderProgram) {
                ((GlShaderProgram)this.fsr1EASUShader).compile(true);
            }
            if (this.fsr1RCASShader instanceof GlShaderProgram) {
                ((GlShaderProgram)this.fsr1RCASShader).compile(true);
            }
        } else {
            this.fsr1EASUShader.compile();
            this.fsr1RCASShader.compile();
        }
    }

    private Vector3i getWorkGroupSize() {
        int workRegionDim = 16;
        int dispatchX = (RenderHandlerManager.getScreenWidth() + (workRegionDim - 1)) / workRegionDim;
        int dispatchY = (RenderHandlerManager.getScreenHeight() + (workRegionDim - 1)) / workRegionDim;
        return new Vector3i(dispatchX, dispatchY, 1);
    }

    public static int checkFP16Support() {
        if (GraphicsCapabilities.hasGLExtension("GL_EXT_shader_16bit_storage") && GraphicsCapabilities.hasGLExtension("GL_EXT_shader_explicit_arithmetic_types")) {
            return 1;
        }
        if (GraphicsCapabilities.hasGLExtension("GL_NV_gpu_shader5")) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean dispatch(DispatchResource dispatchResource) {
        super.dispatch(dispatchResource);
        RenderSystems.current().device().commandEncoder().begin();
        this.fsr1UBOData.setVec2("renderViewportSize", RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight());
        this.fsr1UBOData.setVec2("containerTextureSize", RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight());
        this.fsr1UBOData.setVec2("upscaledViewportSize", RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight());
        this.fsr1UBOData.setFloat("sharpness", SuperResolutionConfig.getSharpness());
        this.fsr1UBOData.fillBuffer();
        this.fsr1UBO.upload();
        PipelineComputeJob easuJob = (PipelineComputeJob)this.fsrUpscalePipeline.job("fsr1_easu");
        PipelineJobResource.SamplerTexture inImageResource = (PipelineJobResource.SamplerTexture)easuJob.resource("inImage");
        if (inImageResource != null && this.getResources().colorTexture() != null) {
            inImageResource.setResource(this.getResources().colorTexture());
        }
        this.fsrUpscalePipeline.execute(RenderSystems.current().device().commandEncoder().getCommandBuffer());
        RenderSystems.current().device().submitCommandBuffer(RenderSystems.current().device().commandEncoder().end());
        return true;
    }

    @Override
    public void destroy() {
        this.output.destroy();
        this.fsr1TempTexture.destroy();
        this.fsr1EASUShader.destroy();
        this.fsr1RCASShader.destroy();
        this.fsr1UBOData.free();
        this.fsr1UBO.destroy();
        this.outputFbo.destroy();
    }

    @Override
    public void resize(int width, int height) {
        this.fsr1TempTexture.resize(width, height);
        this.output.resize(width, height);
        this.outputFbo.resizeFrameBuffer(width, height);
    }

    @Override
    public IFrameBuffer getOutputFrameBuffer() {
        return this.outputFbo;
    }

    @Override
    public int getOutputTextureId() {
        return Math.toIntExact(this.output.handle());
    }
}

