/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.upscale.fsr2;

import com.mojang.blaze3d.systems.RenderSystem;
import io.homo.superresolution.api.AbstractAlgorithm;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.common.minecraft.handler.ShaderCompatHandler;
import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.graphics.opengl.texture.GlTexture2D;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2Context;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2ContextConfig;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2ContextFlags;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2Dimensions;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2DispatchDescription;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2Utils;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2Version;
import org.joml.Matrix4f;
import org.joml.Vector2f;

public class FSR2
extends AbstractAlgorithm {
    public Fsr2Context fsr2Context;
    private GlFrameBuffer outputFbo;
    private GlTexture2D output;
    private GlTexture2D exposureTexture;
    private GlTexture2D inputTexture;

    public FSR2() {
        RenderSystem.assertOnRenderThread();
    }

    @Override
    public void resize(int width, int height) {
        RenderSystem.assertOnRenderThread();
        this.inputTexture.getMipmapSettings().bias((float)(Math.log((double)RenderHandlerManager.getRenderWidth() / (double)RenderHandlerManager.getScreenWidth()) / Math.log(2.0) - 1.0));
        this.output.resize(width, height);
        this.outputFbo.resizeFrameBuffer(width, height);
        this.inputTexture.resize(RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight());
        this.fsr2Context.resize(new Fsr2Dimensions(RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight(), RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight()));
    }

    @Override
    public void init() {
        this.output = (GlTexture2D)RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).width(RenderHandlerManager.getScreenWidth()).height(RenderHandlerManager.getScreenHeight()).format(SuperResolutionConfig.getInternalTextureFormat()).usages(TextureUsages.create().sampler().storage()).label("SRFsr2Output").build());
        this.outputFbo = GlFrameBuffer.create(this.output, null, RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight());
        this.outputFbo.label("SRFsr2OutputFbo");
        this.exposureTexture = (GlTexture2D)RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).width(1).height(1).format(TextureFormat.R8).usages(TextureUsages.create().sampler().storage()).label("SRFsr2ExposureTexture").build());
        this.inputTexture = (GlTexture2D)RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).width(RenderHandlerManager.getRenderWidth()).height(RenderHandlerManager.getRenderHeight()).format(SuperResolutionConfig.getInternalTextureFormat()).mipmapsAuto().usages(TextureUsages.create().sampler().storage()).label("SRFsr2InputTexture").build());
        this.fsr2Context = new Fsr2Context(Fsr2ContextConfig.create().flags(new Fsr2ContextFlags()).version((Fsr2Version)((Object)SuperResolutionConfig.SPECIAL.FSR2.VERSION.get())), new Fsr2Dimensions(RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight(), RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight()));
        this.fsr2Context.init();
        this.resize(RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight());
    }

    @Override
    public boolean dispatch(DispatchResource dispatchResource) {
        return this.dispatchFSR2(dispatchResource);
    }

    @Override
    public void destroy() {
        this.output.destroy();
        this.outputFbo.destroy();
        this.fsr2Context.destroy();
        this.exposureTexture.destroy();
    }

    private boolean dispatchFSR2(DispatchResource dispatchResource) {
        super.dispatch(dispatchResource);
        if (this.fsr2Context == null) {
            return false;
        }
        Matrix4f projectionMatrix = dispatchResource.projectionMatrix();
        float m11 = projectionMatrix.m11();
        float cameraFovAngleVertical = dispatchResource.verticalFov();
        Fsr2DispatchDescription dispatchDescription = new Fsr2DispatchDescription();
        dispatchDescription.setColor(this.resources.colorTexture());
        dispatchDescription.setDepth(this.resources.depthTexture());
        dispatchDescription.setMotionVectors(this.resources.motionVectorsTexture());
        dispatchDescription.setOutput(this.output);
        dispatchDescription.setJitterOffset(this.getOriginJitterOffset(dispatchResource.frameCount(), dispatchResource.renderSize(), dispatchResource.screenSize()));
        dispatchDescription.setExposure(this.exposureTexture);
        dispatchDescription.setRenderSize(new Vector2f((float)dispatchResource.renderWidth(), (float)dispatchResource.renderHeight()));
        dispatchDescription.enableSharpening = false;
        dispatchDescription.sharpness = 1.0f - SuperResolutionConfig.getSharpness();
        dispatchDescription.frameTimeDelta = dispatchResource.frameTimeDelta();
        dispatchDescription.preExposure = 1.0f;
        dispatchDescription.reset = false;
        dispatchDescription.cameraNear = dispatchResource.cameraNear();
        dispatchDescription.cameraFar = dispatchResource.cameraFar();
        dispatchDescription.cameraFovAngleVertical = cameraFovAngleVertical;
        dispatchDescription.viewSpaceToMetersFactor = 1.0f;
        dispatchDescription.deviceDepthNegativeOneToOne = false;
        RenderSystems.opengl().device().commandEncoder().begin();
        dispatchDescription.commandBuffer = RenderSystems.opengl().device().commandEncoder().getCommandBuffer();
        this.fsr2Context.dispatch(dispatchDescription);
        RenderSystems.opengl().device().submitCommandBuffer(RenderSystems.opengl().device().commandEncoder().end());
        return true;
    }

    @Override
    public IFrameBuffer getOutputFrameBuffer() {
        return this.outputFbo;
    }

    @Override
    public int getOutputTextureId() {
        return Math.toIntExact(this.output.handle());
    }

    @Override
    public Vector2f getJitterOffset(int frameCount, Vector2f renderSize, Vector2f screenSize) {
        Vector2f originJitter = this.getOriginJitterOffset(frameCount, renderSize, screenSize);
        return new Vector2f(originJitter.x, originJitter.y);
    }

    private Vector2f getOriginJitterOffset(int frameCount, Vector2f renderSize, Vector2f screenSize) {
        if (!ShaderCompatHandler.isShaderPackCompatSuperResolution()) {
            return new Vector2f(0.0f);
        }
        int jitterPhaseCount = Fsr2Utils.ffxFsr2GetJitterPhaseCount(renderSize.x, screenSize.x);
        return Fsr2Utils.ffxFsr2GetJitterOffset(frameCount, jitterPhaseCount);
    }

    @Override
    public boolean isSupportJitter() {
        return true;
    }
}

