/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.glslang;

import io.homo.superresolution.core.graphics.glslang.enums.GlslangCompileShaderError;
import java.nio.ByteBuffer;

public class GlslangCompileShaderResult {
    private final String sourceCode;
    private final String preprocessedCode;
    private final long spirVDataSize;
    private final ByteBuffer spirvBuffer;
    private final GlslangCompileShaderError error;
    private final String log;

    public GlslangCompileShaderResult(String sourceCode, String preprocessedCode, int error, long spirVDataSize, ByteBuffer spirvBuffer, String log) {
        this.sourceCode = sourceCode;
        this.preprocessedCode = preprocessedCode;
        this.spirVDataSize = spirVDataSize;
        this.spirvBuffer = spirvBuffer;
        this.log = log;
        this.error = error == GlslangCompileShaderError.OK.getValue() ? GlslangCompileShaderError.OK : (error == GlslangCompileShaderError.LINK_ERROR.getValue() ? GlslangCompileShaderError.LINK_ERROR : (error == GlslangCompileShaderError.PREPROCESS_ERROR.getValue() ? GlslangCompileShaderError.PREPROCESS_ERROR : (error == GlslangCompileShaderError.PARSE_ERROR.getValue() ? GlslangCompileShaderError.PARSE_ERROR : GlslangCompileShaderError.OK)));
    }

    public String log() {
        return this.log;
    }

    public String sourceCode() {
        return this.sourceCode;
    }

    public String preprocessedCode() {
        return this.preprocessedCode;
    }

    public long spirVDataSize() {
        return this.spirVDataSize;
    }

    public ByteBuffer spirvBuffer() {
        return this.spirvBuffer;
    }

    public GlslangCompileShaderError error() {
        return this.error;
    }

    public String toString() {
        return "GlslangCompileShaderResult{sourceCode='" + this.sourceCode + "', preprocessedCode='" + this.preprocessedCode + "', spirVDataSize=" + this.spirVDataSize + ", spirvBuffer=" + String.valueOf(this.spirvBuffer) + ", error=" + String.valueOf((Object)this.error) + ", log='" + this.log + "'}";
    }
}

