/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.buffer;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.lwjgl.system.MemoryUtil;

public interface IBufferData {
    public Buffer container();

    public long size();

    default public long containerPtr() {
        return MemoryUtil.memAddress((Buffer)this.container());
    }

    public void free();

    default public ByteBuffer asByteBuffer() {
        return MemoryUtil.memByteBuffer((long)this.containerPtr(), (int)this.container().limit());
    }

    default public void get(byte[] dest, long offset) {
        ByteBuffer buffer = this.asByteBuffer();
        Objects.requireNonNull(dest, "Destination array cannot be null");
        if (offset < 0L || offset + (long)dest.length > this.size()) {
            throw new IndexOutOfBoundsException("Invalid offset or data length");
        }
        int position = buffer.position();
        buffer.position((int)offset);
        buffer.get(dest);
        buffer.position(position);
    }

    public void put(byte[] var1, long var2);

    public void updatePartial(Buffer var1, long var2, long var4);

    public void update(Buffer var1);
}

