/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.command;

import io.homo.superresolution.core.graphics.impl.DrawObject;
import io.homo.superresolution.core.graphics.impl.buffer.IBuffer;
import io.homo.superresolution.core.graphics.impl.command.ICommandBuffer;
import io.homo.superresolution.core.graphics.impl.command.commands.ClearCommand;
import io.homo.superresolution.core.graphics.impl.command.commands.ComputeCommand;
import io.homo.superresolution.core.graphics.impl.command.commands.CopyBufferCommand;
import io.homo.superresolution.core.graphics.impl.command.commands.CopyTextureCommand;
import io.homo.superresolution.core.graphics.impl.command.commands.DrawCommand;
import io.homo.superresolution.core.graphics.impl.command.commands.GpuCommand;
import io.homo.superresolution.core.graphics.impl.device.IDevice;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.shader.IShaderProgram;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.system.IRenderState;

public interface ICommandDecoder {
    public void clearTextureRGBA(ICommandBuffer var1, ITexture var2, float[] var3);

    public void clearTextureDepth(ICommandBuffer var1, ITexture var2, float var3);

    public void clearTextureStencil(ICommandBuffer var1, ITexture var2, int var3);

    public void copyTexture(ICommandBuffer var1, ITexture var2, ITexture var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13);

    public void copyBuffer(ICommandBuffer var1, IBuffer var2, IBuffer var3, long var4, long var6, long var8);

    public void draw(ICommandBuffer var1, IShaderProgram<?> var2, IFrameBuffer var3, DrawObject var4, int var5, int var6);

    public void dispatchCompute(ICommandBuffer var1, IShaderProgram<?> var2, int var3, int var4, int var5);

    default public void decodeClearTexture(ICommandBuffer commandBuffer, ClearCommand command) {
        switch (command.clearMode) {
            case 0: {
                this.clearTextureRGBA(commandBuffer, command.target, command.colorRGBA);
            }
            case 1: {
                this.clearTextureDepth(commandBuffer, command.target, command.depth);
            }
            case 2: {
                this.clearTextureStencil(commandBuffer, command.target, command.stencil);
            }
        }
    }

    default public void decodeCopyTexture(ICommandBuffer commandBuffer, CopyTextureCommand command) {
        this.copyTexture(commandBuffer, command.source, command.destination, command.sourceDimensions.x, command.sourceDimensions.y, command.sourceDimensions.z, command.sourceDimensions.w, command.sourceLevel, command.destinationDimensions.x, command.destinationDimensions.y, command.destinationDimensions.z, command.destinationDimensions.w, command.destinationLevel);
    }

    default public void decodeCopyBuffer(ICommandBuffer commandBuffer, CopyBufferCommand command) {
        this.copyBuffer(commandBuffer, command.source, command.destination, command.srcOffset, command.dstOffset, command.size);
    }

    default public void decodeDraw(ICommandBuffer commandBuffer, DrawCommand command) {
        this.applyRenderState(commandBuffer, command.stateSnapshot);
        this.draw(commandBuffer, command.program, command.frameBuffer, command.drawObject, command.firstVertex, command.vertexCount);
    }

    default public void decodeDispatchCompute(ICommandBuffer commandBuffer, ComputeCommand command) {
        this.dispatchCompute(commandBuffer, command.shaderProgram, command.workGroupSize.x, command.workGroupSize.y, command.workGroupSize.z);
    }

    public void applyRenderState(ICommandBuffer var1, IRenderState.StateSnapshot var2);

    default public void decodeCommand(ICommandBuffer commandBuffer, GpuCommand command) {
        switch (command.getCommandType()) {
            case Draw: {
                this.decodeDraw(commandBuffer, (DrawCommand)command);
                break;
            }
            case Clear: {
                this.decodeClearTexture(commandBuffer, (ClearCommand)command);
                break;
            }
            case Compute: {
                this.decodeDispatchCompute(commandBuffer, (ComputeCommand)command);
                break;
            }
            case CopyBuffer: {
                this.decodeCopyBuffer(commandBuffer, (CopyBufferCommand)command);
                break;
            }
            case CopyTexture: {
                this.decodeCopyTexture(commandBuffer, (CopyTextureCommand)command);
            }
        }
    }

    public IDevice getDevice();
}

