/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.shader.uniform;

import io.homo.superresolution.core.graphics.impl.shader.uniform.ShaderUniformAccess;
import io.homo.superresolution.core.graphics.impl.shader.uniform.ShaderUniformType;

public class ShaderUniformDescription {
    private final String name;
    private final ShaderUniformType type;
    private int binding = -1;
    private int bufferSize = -1;
    private ShaderUniformAccess access = ShaderUniformAccess.Both;

    private ShaderUniformDescription(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.binding = builder.binding;
        this.bufferSize = builder.bufferSize;
        this.access = builder.access;
    }

    public static Builder builder(String name, ShaderUniformType type) {
        return new Builder(name, type);
    }

    public ShaderUniformAccess access() {
        return this.access;
    }

    public String name() {
        return this.name;
    }

    public ShaderUniformType type() {
        return this.type;
    }

    public int binding() {
        return this.binding;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public static class Builder {
        private final String name;
        private final ShaderUniformType type;
        private int binding = -1;
        private int bufferSize = -1;
        private ShaderUniformAccess access = ShaderUniformAccess.Both;

        public Builder(String name, ShaderUniformType type) {
            this.name = name;
            this.type = type;
        }

        public Builder access(ShaderUniformAccess access) {
            this.access = access;
            return this;
        }

        public Builder binding(int binding) {
            this.binding = binding;
            return this;
        }

        public Builder bufferSize(int size) {
            if (this.type != ShaderUniformType.UniformBuffer) {
                throw new IllegalArgumentException("Buffer size only applicable to uniform blocks");
            }
            this.bufferSize = size;
            return this;
        }

        public ShaderUniformDescription build() {
            return new ShaderUniformDescription(this);
        }
    }
}

