/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.texture;

import io.homo.superresolution.core.graphics.impl.texture.TextureFilterMode;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureMipmapSettings;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsage;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.impl.texture.TextureWrapMode;
import java.util.Objects;

public class TextureDescription {
    private int width;
    private int height;
    private TextureFormat format;
    private TextureType type;
    private TextureUsages usages = TextureUsages.create();
    private TextureFilterMode filterMode = TextureFilterMode.Nearest;
    private TextureWrapMode wrapMode = TextureWrapMode.ClampToEdge;
    private TextureMipmapSettings mipmapSettings = TextureMipmapSettings.disabled();
    private String label;

    private TextureDescription() {
    }

    public String getLabel() {
        return this.label;
    }

    public static Builder create() {
        return new Builder();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public TextureFormat getFormat() {
        return this.format;
    }

    public TextureType getType() {
        return this.type;
    }

    public TextureUsages getUsages() {
        return this.usages;
    }

    public TextureFilterMode getFilterMode() {
        return this.filterMode;
    }

    public TextureWrapMode getWrapMode() {
        return this.wrapMode;
    }

    public TextureMipmapSettings getMipmapSettings() {
        return this.mipmapSettings;
    }

    public String toString() {
        return "TextureDescription{width=" + this.width + ", height=" + this.height + ", format=" + String.valueOf((Object)this.format) + ", type=" + String.valueOf((Object)this.type) + ", usages=" + String.valueOf(this.usages) + ", filterMode=" + String.valueOf((Object)this.filterMode) + ", wrapMode=" + String.valueOf((Object)this.wrapMode) + ", mipmap=" + String.valueOf(this.mipmapSettings) + "}";
    }

    public static class Builder {
        private final TextureDescription description = new TextureDescription();

        public Builder width(int width) {
            if (width <= 0) {
                throw new IllegalArgumentException("Width must be positive");
            }
            this.description.width = width;
            return this;
        }

        public Builder height(int height) {
            if (height <= 0) {
                throw new IllegalArgumentException("Height must be positive");
            }
            this.description.height = height;
            return this;
        }

        public Builder size(int width, int height) {
            return this.width(width).height(height);
        }

        public Builder format(TextureFormat format) {
            this.description.format = Objects.requireNonNull(format, "TextureFormat cannot be null");
            return this;
        }

        public Builder type(TextureType type) {
            this.description.type = Objects.requireNonNull(type, "TextureType cannot be null");
            return this;
        }

        public Builder usages(TextureUsages usages) {
            if (usages == null || usages.isEmpty()) {
                throw new IllegalArgumentException("At least one usage must be specified");
            }
            this.description.usages = usages.copy();
            return this;
        }

        public Builder filterMode(TextureFilterMode filterMode) {
            this.description.filterMode = Objects.requireNonNull(filterMode, "FilterMode cannot be null");
            return this;
        }

        public Builder wrapMode(TextureWrapMode wrapMode) {
            this.description.wrapMode = Objects.requireNonNull(wrapMode, "WrapMode cannot be null");
            return this;
        }

        public Builder mipmapSettings(TextureMipmapSettings mipmapSettings) {
            this.description.mipmapSettings = mipmapSettings;
            return this;
        }

        public Builder mipmapsDisabled() {
            this.description.mipmapSettings = TextureMipmapSettings.disabled();
            return this;
        }

        public Builder mipmapsAuto() {
            this.description.mipmapSettings = TextureMipmapSettings.auto();
            return this;
        }

        public Builder label(String label) {
            this.description.label = label;
            return this;
        }

        public Builder mipmapsManual(int levels) {
            this.description.mipmapSettings = TextureMipmapSettings.manual(levels);
            return this;
        }

        public TextureDescription build() {
            if (this.description.usages.getUsages().contains((Object)TextureUsage.AttachmentDepth) && !this.description.format.name().toUpperCase().startsWith("DEPTH")) {
                throw new IllegalStateException("Depth attachment requires a depth texture format");
            }
            return this.description;
        }
    }
}

