/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.texture;

public class TextureMipmapSettings {
    private final boolean enabled;
    private final int levels;
    private float bias;
    private final boolean autoGenerate;

    public float getBias() {
        return this.bias;
    }

    public TextureMipmapSettings bias(float bias) {
        this.bias = bias;
        return this;
    }

    private TextureMipmapSettings(boolean enabled, int levels, boolean autoGenerate, float bias) {
        this.enabled = enabled;
        this.levels = levels;
        this.autoGenerate = autoGenerate;
        this.bias = bias;
    }

    private TextureMipmapSettings(boolean enabled, int levels, boolean autoGenerate) {
        this(enabled, levels, autoGenerate, 0.0f);
    }

    public static TextureMipmapSettings disabled() {
        return new TextureMipmapSettings(false, 1, false);
    }

    public static TextureMipmapSettings auto() {
        return new TextureMipmapSettings(true, -1, true);
    }

    public static TextureMipmapSettings manual(int levels) {
        if (levels < 1) {
            throw new IllegalArgumentException("Mipmap levels must be at least 1");
        }
        return new TextureMipmapSettings(true, levels, false);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getLevels() {
        return this.enabled ? this.levels : 1;
    }

    public boolean isAutoGenerate() {
        return this.autoGenerate;
    }

    public int resolveLevels(int width, int height) {
        if (!this.enabled) {
            return 1;
        }
        if (this.levels > 0) {
            return this.levels;
        }
        int maxDim = Math.max(width, height);
        return (int)(Math.log(maxDim) / Math.log(2.0)) + 1;
    }

    public String toString() {
        if (!this.enabled) {
            return "MipmapDisabled";
        }
        if (this.levels < 0) {
            return "MipmapAuto";
        }
        return "MipmapLevels=" + this.levels + ", Generate=" + (this.autoGenerate ? "Auto" : "Manual");
    }
}

