/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.opengl.buffer;

import io.homo.superresolution.core.graphics.impl.buffer.BufferDescription;
import io.homo.superresolution.core.graphics.impl.buffer.BufferUsage;
import io.homo.superresolution.core.graphics.impl.buffer.IBuffer;
import io.homo.superresolution.core.graphics.impl.buffer.IBufferData;
import io.homo.superresolution.core.graphics.opengl.Gl;
import org.lwjgl.opengl.GL41;
import org.lwjgl.opengl.GL45C;

public class GlBuffer
implements IBuffer {
    private final int glId;
    private final long size;
    private final BufferUsage usage;
    private IBufferData bufferData;

    public GlBuffer(BufferDescription description) {
        this.size = description.size();
        this.usage = description.usage();
        this.glId = Gl.DSA.createBuffer();
        if (Gl.isSupportDSA()) {
            GL45C.glNamedBufferData((int)this.glId, (int[])new int[0], (int)this.getGlUsage());
        } else {
            GL41.glBufferData((int)this.glId, (int[])new int[0], (int)this.getGlUsage());
        }
    }

    @Override
    public IBufferData data() {
        return this.bufferData;
    }

    @Override
    public void upload() {
        if (this.bufferData == null) {
            throw new RuntimeException();
        }
        Gl.DSA.bufferData(this.glId, this.getGlTarget(), this.bufferData.container(), this.getGlUsage());
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public BufferUsage getUsage() {
        return this.usage;
    }

    @Override
    public void setBufferData(IBufferData bufferData) {
        this.bufferData = bufferData;
    }

    @Override
    public long handle() {
        return this.glId;
    }

    private int getGlTarget() {
        return switch (this.usage) {
            case BufferUsage.Ubo -> 35345;
            case BufferUsage.CopySrc -> 36662;
            case BufferUsage.CopyDst -> 36663;
            default -> 34962;
        };
    }

    private int getGlUsage() {
        return switch (this.usage) {
            case BufferUsage.StaticDraw -> 35044;
            case BufferUsage.DynamicDraw -> 35048;
            case BufferUsage.Ubo -> 35048;
            default -> 35044;
        };
    }

    @Override
    public void destroy() {
        Gl.DSA.deleteBuffer(this.glId);
    }
}

