/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.opengl.texture;

import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.core.graphics.opengl.GlState;
import io.homo.superresolution.core.graphics.opengl.texture.GlTexture2D;
import io.homo.superresolution.core.graphics.vulkan.VulkanInterop;
import io.homo.superresolution.core.graphics.vulkan.texture.VulkanTexture;
import org.lwjgl.opengl.EXTMemoryObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryStack;

public class GlImportableTexture2D
extends GlTexture2D {
    private int glMemoryObject = 0;
    private final VulkanTexture sourceTexture;

    public GlImportableTexture2D(VulkanTexture sourceTexture) {
        super(sourceTexture.getTextureDescription());
        this.sourceTexture = sourceTexture;
        this.initializeTexture();
    }

    @Override
    protected void initializeTexture() {
        try (GlState ignored = new GlState(448L);
             MemoryStack stack = MemoryStack.stackPush();){
            this.configureTextureParameters();
            long handle = this.sourceTexture.getExportedMemoryHandle();
            long size = this.sourceTexture.getMemorySize();
            SuperResolution.LOGGER.info("OpenGL-Vulkan interop texture: MemoryHandle {} MemorySize {}bits Size {}x{}px PixelSize {} Levels {} Format {}", new Object[]{handle, size, this.sourceTexture.getWidth(), this.sourceTexture.getHeight(), this.sourceTexture.getTextureFormat().getBytesPerPixel(), this.sourceTexture.getMipmapSettings().getLevels(), this.sourceTexture.getTextureFormat()});
            int[] memoryObjects = new int[1];
            EXTMemoryObject.glCreateMemoryObjectsEXT((int[])memoryObjects);
            this.glMemoryObject = memoryObjects[0];
            VulkanInterop.IMPL.glImportMemoryEXT(this.glMemoryObject, size, handle);
            GL11.glBindTexture((int)3553, (int)((int)this.handle()));
            EXTMemoryObject.glTextureStorageMem2DEXT((int)((int)this.handle()), (int)this.sourceTexture.getMipmapSettings().getLevels(), (int)this.sourceTexture.getTextureFormat().gl(), (int)this.sourceTexture.getWidth(), (int)this.sourceTexture.getHeight(), (int)this.glMemoryObject, (long)0L);
        }
    }

    @Override
    public void resize(int width, int height) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroy() {
        super.destroy();
        EXTMemoryObject.glDeleteMemoryObjectsEXT((int)this.glMemoryObject);
    }
}

