/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.opengl.texture;

import io.homo.superresolution.core.graphics.impl.GpuObject;
import io.homo.superresolution.core.graphics.opengl.Gl;
import io.homo.superresolution.core.impl.Destroyable;

public class GlSampler
implements GpuObject,
Destroyable {
    private int handle = Gl.DSA.createSampler();

    protected GlSampler(SamplerType type) {
        switch (type) {
            case LinearClamp: {
                Gl.DSA.samplerParameteri(this.handle, 10242, 33071);
                Gl.DSA.samplerParameteri(this.handle, 10243, 33071);
                Gl.DSA.samplerParameteri(this.handle, 32882, 33071);
                Gl.DSA.samplerParameteri(this.handle, 10241, 9985);
                Gl.DSA.samplerParameteri(this.handle, 10240, 9729);
                break;
            }
            case LinearRepeat: {
                Gl.DSA.samplerParameteri(this.handle, 10242, 10497);
                Gl.DSA.samplerParameteri(this.handle, 10243, 10497);
                Gl.DSA.samplerParameteri(this.handle, 32882, 10497);
                Gl.DSA.samplerParameteri(this.handle, 10241, 9987);
                Gl.DSA.samplerParameteri(this.handle, 10240, 9729);
                break;
            }
            case NearestClamp: {
                Gl.DSA.samplerParameteri(this.handle, 10242, 33071);
                Gl.DSA.samplerParameteri(this.handle, 10243, 33071);
                Gl.DSA.samplerParameteri(this.handle, 32882, 33071);
                Gl.DSA.samplerParameteri(this.handle, 10241, 9984);
                Gl.DSA.samplerParameteri(this.handle, 10240, 9728);
            }
        }
    }

    public static GlSampler create(SamplerType type) {
        return new GlSampler(type);
    }

    public String toString() {
        return "GlSampler{handle=" + this.handle + "}";
    }

    @Override
    public long handle() {
        return this.handle;
    }

    @Override
    public void destroy() {
        if (this.handle > 0) {
            Gl.DSA.deleteSampler(this.handle);
        }
        this.handle = 0;
    }

    public static enum SamplerType {
        NearestClamp,
        LinearRepeat,
        LinearClamp;

    }
}

