/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.opengl.texture;

import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFilterMode;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureMipmapSettings;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.impl.texture.TextureWrapMode;
import io.homo.superresolution.core.graphics.opengl.Gl;

public class GlTextureView
implements ITexture {
    private final ITexture parent;
    private final int type;
    private final int minLevel;
    private final int numLevels;
    private final int minLayer;
    private final int numLayers;
    private int id;

    private GlTextureView(ITexture parent, int type, int minLevel, int numLevels, int minLayer, int numLayers, int id) {
        this.parent = parent;
        this.type = type;
        this.minLevel = minLevel;
        this.numLevels = numLevels;
        this.minLayer = minLayer;
        this.numLayers = numLayers;
        this.id = id;
    }

    public static GlTextureView create(ITexture parent, int type, int minLevel, int numLevels, int minLayer, int numLayers) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent texture cannot be null");
        }
        if (parent.handle() == 0L) {
            throw new IllegalStateException("Parent texture is not initialized");
        }
        int viewId = Gl.DSA.createTextureView((int)parent.handle(), type, parent.getTextureFormat().gl(), minLevel, numLevels, minLayer, numLayers);
        return new GlTextureView(parent, type, minLevel, numLevels, minLayer, numLayers, viewId);
    }

    public ITexture getParent() {
        return this.parent;
    }

    public int getType() {
        return this.type;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getNumLevels() {
        return this.numLevels;
    }

    public int getMinLayer() {
        return this.minLayer;
    }

    public int getNumLayers() {
        return this.numLayers;
    }

    @Override
    public long handle() {
        return this.id;
    }

    @Override
    public TextureFormat getTextureFormat() {
        return this.parent.getTextureFormat();
    }

    @Override
    public TextureUsages getTextureUsages() {
        return this.parent.getTextureUsages();
    }

    @Override
    public TextureType getTextureType() {
        return this.parent.getTextureType();
    }

    @Override
    public TextureFilterMode getTextureFilterMode() {
        return this.parent.getTextureFilterMode();
    }

    @Override
    public TextureWrapMode getTextureWrapMode() {
        return this.parent.getTextureWrapMode();
    }

    @Override
    public TextureMipmapSettings getMipmapSettings() {
        return this.parent.getMipmapSettings();
    }

    @Override
    public TextureDescription getTextureDescription() {
        return this.parent.getTextureDescription();
    }

    @Override
    public int getWidth() {
        return this.parent.getWidth();
    }

    @Override
    public int getHeight() {
        return this.parent.getHeight();
    }

    @Override
    public void destroy() {
        Gl.DSA.deleteTexture(this.id);
        this.id = -1;
    }

    @Override
    public void resize(int width, int height) {
        throw new RuntimeException("GlTextureView\u4e0d\u53ef\u66f4\u6539\u5927\u5c0f");
    }
}

