/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.opengl.utils;

import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.CopyOperation;
import io.homo.superresolution.core.graphics.impl.DrawObject;
import io.homo.superresolution.core.graphics.impl.shader.ShaderDescription;
import io.homo.superresolution.core.graphics.impl.shader.ShaderSource;
import io.homo.superresolution.core.graphics.impl.shader.ShaderType;
import io.homo.superresolution.core.graphics.impl.shader.uniform.ShaderUniformAccess;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.opengl.Gl;
import io.homo.superresolution.core.graphics.opengl.GlDebug;
import io.homo.superresolution.core.graphics.opengl.GlState;
import io.homo.superresolution.core.graphics.opengl.shader.GlShaderProgram;
import io.homo.superresolution.core.graphics.opengl.texture.GlSampler;
import io.homo.superresolution.core.graphics.system.IRenderState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL43;

public class GlTextureCopier {
    private static final Map<String, GlShaderProgram> programMap = new HashMap<String, GlShaderProgram>();
    private static final Map<String, GlShaderProgram> computeProgramMap = new HashMap<String, GlShaderProgram>();
    private static GlSampler sampler;
    private static int cachedFrameBuffer;

    public static int getCachedFrameBuffer() {
        return cachedFrameBuffer;
    }

    private static String toComputeShaderFormatQualifier(TextureFormat format) {
        return switch (format) {
            case TextureFormat.RGBA8 -> "rgba8";
            case TextureFormat.RGBA16F -> "rgba16f";
            case TextureFormat.RGBA16 -> "rgba16";
            case TextureFormat.RG16F -> "rg16f";
            case TextureFormat.RG32F -> "rg32f";
            case TextureFormat.RG8 -> "rg8";
            case TextureFormat.R16F -> "r16f";
            case TextureFormat.R8 -> "r8";
            case TextureFormat.R32F -> "r32f";
            case TextureFormat.R32UI -> "r32ui";
            case TextureFormat.R16_SNORM -> "r16_snorm";
            case TextureFormat.R11G11B10F -> "r11f_g11f_b10f";
            default -> null;
        };
    }

    private static GlShaderProgram getOrCreateComputeProgram(CopyOperation copyOperation) {
        String key = GlTextureCopier.mappingKey(copyOperation.getMappings());
        if (computeProgramMap.containsKey(key)) {
            return computeProgramMap.get(key);
        }
        ShaderDescription.Builder builder = ShaderDescription.compute(new ShaderSource(ShaderType.Compute, "/shader/copy.comp.glsl", true));
        builder.addDefine("COPY_CHANCEL", String.valueOf(copyOperation.getMappings().size()));
        for (int i = 0; i < copyOperation.getMappings().size(); ++i) {
            CopyOperation.ChannelMapping map = copyOperation.getMappings().get(i);
            builder.addDefine("COPY_SRC_CHANCEL" + i, String.valueOf(map.src.ordinal()));
            builder.addDefine("COPY_DST_CHANCEL" + i, String.valueOf(map.dst.ordinal()));
        }
        builder.addDefine("COPY_DST_FORMAT", GlTextureCopier.toComputeShaderFormatQualifier(copyOperation.getDstTexture().getTextureFormat()));
        builder.uniformSamplerTexture("tex", 0);
        builder.uniformStorageTexture("outImage", ShaderUniformAccess.Write, 0);
        GlShaderProgram program = RenderSystems.opengl().device().createShaderProgram(builder.build());
        program.compile();
        computeProgramMap.put(key, program);
        return program;
    }

    private static GlShaderProgram getOrCreateProgram(CopyOperation copyOperation) {
        String key = GlTextureCopier.mappingKey(copyOperation.getMappings());
        if (programMap.containsKey(key)) {
            return programMap.get(key);
        }
        ShaderDescription.Builder builder = ShaderDescription.graphics(new ShaderSource(ShaderType.Fragment, "/shader/copy.frag.glsl", true), new ShaderSource(ShaderType.Vertex, "/shader/copy.vert.glsl", true));
        builder.addDefine("COPY_CHANCEL", String.valueOf(copyOperation.getMappings().size()));
        for (int i = 0; i < copyOperation.getMappings().size(); ++i) {
            CopyOperation.ChannelMapping map = copyOperation.getMappings().get(i);
            builder.addDefine("COPY_SRC_CHANCEL" + i, String.valueOf(map.src.ordinal()));
            builder.addDefine("COPY_DST_CHANCEL" + i, String.valueOf(map.dst.ordinal()));
        }
        builder.uniformSamplerTexture("tex", 0);
        GlShaderProgram program = RenderSystems.opengl().device().createShaderProgram(builder.build());
        program.compile();
        programMap.put(key, program);
        return program;
    }

    private static String mappingKey(List<CopyOperation.ChannelMapping> mappings) {
        return mappings.stream().map(m -> m.src.ordinal() + "->" + m.dst.ordinal()).collect(Collectors.joining(","));
    }

    public static void copy(CopyOperation copyOperation) {
        GlDebug.pushGroup(GlDebug.nextCopyId(), "CopyTexture");
        if (sampler == null) {
            sampler = GlSampler.create(GlSampler.SamplerType.LinearClamp);
        }
        if (GlTextureCopier.toComputeShaderFormatQualifier(copyOperation.getDstTexture().getTextureFormat()) != null) {
            GlShaderProgram program = GlTextureCopier.getOrCreateComputeProgram(copyOperation);
            GL43.glBindSampler((int)0, (int)((int)sampler.handle()));
            RenderSystems.opengl().device().commandEncoder().begin();
            program.uniforms().samplerTexture("tex").set(copyOperation.getSrcTexture());
            program.uniforms().storageTexture("outImage").set(copyOperation.getDstTexture());
            RenderSystems.opengl().device().commandEncoder().dispatchCompute(program, (int)Math.ceil((double)copyOperation.getSrcTexture().getWidth() / 16.0), (int)Math.ceil((double)copyOperation.getSrcTexture().getHeight() / 16.0), 1);
            RenderSystems.opengl().device().submitCommandBuffer(RenderSystems.opengl().device().commandEncoder().end());
            GL43.glBindSampler((int)0, (int)0);
            GlDebug.popGroup();
            return;
        }
        try (GlState state = new GlState(48L);){
            if (cachedFrameBuffer < 0) {
                cachedFrameBuffer = Gl.DSA.createFramebuffer();
                GlDebug.objectLabel(36160, cachedFrameBuffer, "CopyOperationTempFrameBuffer");
            }
            Gl.DSA.framebufferTexture(cachedFrameBuffer, 36064, (int)copyOperation.getDstTexture().handle(), 0);
            GL30.glBindFramebuffer((int)36009, (int)cachedFrameBuffer);
            GlShaderProgram program = GlTextureCopier.getOrCreateProgram(copyOperation);
            IRenderState.StateSnapshot stateSnapshot = RenderSystems.opengl().device().commandEncoder().renderState().get();
            RenderSystems.opengl().device().commandEncoder().begin().renderState().colorMask(true, true, true, true).depthTest(false).depthWrite(false).cullFace(false).viewport(0.0f, 0.0f, copyOperation.getDstTexture().getWidth(), copyOperation.getDstTexture().getHeight());
            program.uniforms().samplerTexture("tex").set(copyOperation.getSrcTexture());
            RenderSystems.opengl().device().commandEncoder().draw(program, null, DrawObject.fullscreenQuad(RenderSystems.opengl().device()).once(), 0, DrawObject.fullscreenQuadVertexCount());
            RenderSystems.opengl().device().commandEncoder().renderState().apply(stateSnapshot);
            RenderSystems.opengl().device().submitCommandBuffer(RenderSystems.opengl().device().commandEncoder().end());
        }
        GlDebug.popGroup();
    }

    static {
        cachedFrameBuffer = -1;
    }
}

