/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.vulkan.command;

import io.homo.superresolution.core.graphics.vulkan.VulkanDevice;
import io.homo.superresolution.core.graphics.vulkan.utils.VulkanException;
import io.homo.superresolution.core.graphics.vulkan.utils.VulkanUtils;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkCommandBufferAllocateInfo;
import org.lwjgl.vulkan.VkCommandPoolCreateInfo;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkQueue;
import org.lwjgl.vulkan.VkQueueFamilyProperties;
import org.lwjgl.vulkan.VkSubmitInfo;

public class VulkanCommandManager {
    private final VulkanDevice device;
    private final List<VkCommandBuffer> allocatedBuffers = new ArrayList<VkCommandBuffer>();
    private int graphicsQueueFamilyIndex;
    private long commandPool;
    private VkQueue graphicsQueue;

    public VulkanCommandManager(VulkanDevice device) {
        this.device = device;
    }

    public void init() {
        this.graphicsQueueFamilyIndex = this.findGraphicsQueueFamilyIndex();
        this.createCommandPool();
        this.createGraphicsQueue();
    }

    public List<VkCommandBuffer> getAllocatedBuffers() {
        return this.allocatedBuffers;
    }

    public long getCommandPool() {
        return this.commandPool;
    }

    public VkQueue getGraphicsQueue() {
        return this.graphicsQueue;
    }

    private int findGraphicsQueueFamilyIndex() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkPhysicalDevice physicalDevice = this.device.getPhysicalDevice();
            int queueFamilyCount = stack.mallocInt(1).get(0);
            VK10.vkGetPhysicalDeviceQueueFamilyProperties((VkPhysicalDevice)physicalDevice, (IntBuffer)stack.ints(queueFamilyCount), null);
            VkQueueFamilyProperties.Buffer queueFamilies = VkQueueFamilyProperties.malloc((int)queueFamilyCount, (MemoryStack)stack);
            VK10.vkGetPhysicalDeviceQueueFamilyProperties((VkPhysicalDevice)physicalDevice, (IntBuffer)stack.ints(queueFamilyCount), (VkQueueFamilyProperties.Buffer)queueFamilies);
            for (int i = 0; i < queueFamilies.capacity(); ++i) {
                if ((((VkQueueFamilyProperties)queueFamilies.get(i)).queueFlags() & 1) == 0) continue;
                int n = i;
                return n;
            }
            throw new VulkanException("No suitable queue family found");
        }
    }

    private void createCommandPool() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkCommandPoolCreateInfo poolInfo = VkCommandPoolCreateInfo.calloc((MemoryStack)stack).sType(39).queueFamilyIndex(this.graphicsQueueFamilyIndex).flags(2);
            LongBuffer pCommandPool = stack.mallocLong(1);
            VulkanUtils.VK_CHECK(VK10.vkCreateCommandPool((VkDevice)this.device.getVkDevice(), (VkCommandPoolCreateInfo)poolInfo, null, (LongBuffer)pCommandPool), "Failed to create command pool");
            this.commandPool = pCommandPool.get(0);
        }
    }

    private void createGraphicsQueue() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pQueue = stack.mallocPointer(1);
            VK10.vkGetDeviceQueue((VkDevice)this.device.getVkDevice(), (int)this.graphicsQueueFamilyIndex, (int)0, (PointerBuffer)pQueue);
            this.graphicsQueue = new VkQueue(pQueue.get(0), this.device.getVkDevice());
        }
    }

    public void freeCommandBuffer(VkCommandBuffer cmdBuf) {
        VK10.vkFreeCommandBuffers((VkDevice)this.device.getVkDevice(), (long)this.commandPool, (VkCommandBuffer)cmdBuf);
    }

    public VkCommandBuffer createCommandBuffer() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkCommandBufferAllocateInfo allocInfo = VkCommandBufferAllocateInfo.calloc((MemoryStack)stack).sType(40).commandPool(this.commandPool).level(0).commandBufferCount(1);
            PointerBuffer pCommandBuffer = stack.mallocPointer(1);
            VulkanUtils.VK_CHECK(VK10.vkAllocateCommandBuffers((VkDevice)this.device.getVkDevice(), (VkCommandBufferAllocateInfo)allocInfo, (PointerBuffer)pCommandBuffer), "Failed to allocate command buffer");
            VkCommandBuffer cmdBuf = new VkCommandBuffer(pCommandBuffer.get(0), this.device.getVkDevice());
            this.allocatedBuffers.add(cmdBuf);
            VkCommandBuffer vkCommandBuffer = cmdBuf;
            return vkCommandBuffer;
        }
    }

    public void submitCommandBuffer(VkCommandBuffer commandBuffer) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkSubmitInfo submitInfo = VkSubmitInfo.calloc((MemoryStack)stack).sType(4).pCommandBuffers(stack.pointers((Pointer)commandBuffer));
            VK10.vkEndCommandBuffer((VkCommandBuffer)commandBuffer);
            VulkanUtils.VK_CHECK(VK10.vkQueueSubmit((VkQueue)this.graphicsQueue, (VkSubmitInfo)submitInfo, (long)0L), "Failed to submit command buffer");
            VK10.vkQueueWaitIdle((VkQueue)this.graphicsQueue);
        }
    }

    public void destroy() {
        VK10.vkDestroyCommandPool((VkDevice)this.device.getVkDevice(), (long)this.commandPool, null);
    }
}

