/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.vulkan.semaphore;

import io.homo.superresolution.core.graphics.vulkan.VulkanDevice;
import io.homo.superresolution.core.graphics.vulkan.VulkanInterop;
import io.homo.superresolution.core.graphics.vulkan.utils.VulkanUtils;
import org.lwjgl.opengl.EXTSemaphore;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.vulkan.VK11;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkQueue;
import org.lwjgl.vulkan.VkSemaphoreCreateInfo;
import org.lwjgl.vulkan.VkSubmitInfo;

public class VkGlInteropSemaphore {
    private final long vkSemaphoreHandle;
    private final long glSemaphoreHandle;
    private final long semaphoreHandle;
    private final VulkanDevice device;

    public long getVkSemaphoreHandle() {
        return this.vkSemaphoreHandle;
    }

    public long getGlSemaphoreHandle() {
        return this.glSemaphoreHandle;
    }

    public long getSemaphoreHandle() {
        return this.semaphoreHandle;
    }

    private VkGlInteropSemaphore(long vkSemaphoreHandle, long glSemaphoreHandle, long semaphoreHandle, VulkanDevice device) {
        this.vkSemaphoreHandle = vkSemaphoreHandle;
        this.glSemaphoreHandle = glSemaphoreHandle;
        this.semaphoreHandle = semaphoreHandle;
        this.device = device;
    }

    public static VkGlInteropSemaphore create(VulkanDevice vulkanDevice) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkSemaphoreCreateInfo semaphoreCreateInfo = VkSemaphoreCreateInfo.calloc((MemoryStack)stack);
            semaphoreCreateInfo.sType(9);
            semaphoreCreateInfo.pNext(VulkanInterop.IMPL.createVkExportSemaphoreCreateInfo(stack).address());
            long[] pVkSemaphore = new long[]{0L};
            VulkanUtils.VK_CHECK(VK11.vkCreateSemaphore((VkDevice)vulkanDevice.getVkDevice(), (VkSemaphoreCreateInfo)semaphoreCreateInfo, null, (long[])pVkSemaphore));
            long pExpSemaphore = VulkanInterop.IMPL.vkGetSemaphoreHandleKHR(stack, vulkanDevice.getVkDevice(), VulkanInterop.IMPL.createVkSemaphoreGetHandleInfoKHR(stack, pVkSemaphore[0]));
            int pGlSemaphores = EXTSemaphore.glGenSemaphoresEXT();
            VulkanInterop.IMPL.glImportSemaphoreHandleEXT(stack, pGlSemaphores, pExpSemaphore);
            VkGlInteropSemaphore vkGlInteropSemaphore = new VkGlInteropSemaphore(pVkSemaphore[0], pGlSemaphores, pExpSemaphore, vulkanDevice);
            return vkGlInteropSemaphore;
        }
    }

    public void destroy() {
        VK11.vkDestroySemaphore((VkDevice)this.device.getVkDevice(), (long)this.vkSemaphoreHandle, null);
        EXTSemaphore.glDeleteSemaphoresEXT((int)((int)this.glSemaphoreHandle));
    }

    public void signalVulkan(long[] commandBuffers) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkSubmitInfo submitInfo = VkSubmitInfo.calloc((MemoryStack)stack).sType(4).pWaitSemaphores(null).pSignalSemaphores(stack.longs(this.vkSemaphoreHandle)).pCommandBuffers(commandBuffers != null ? stack.pointers(commandBuffers) : null);
            VulkanUtils.VK_CHECK(VK11.vkQueueSubmit((VkQueue)this.device.getGraphicsQueue(), (VkSubmitInfo)submitInfo, (long)0L));
            VulkanUtils.VK_CHECK(VK11.vkQueueWaitIdle((VkQueue)this.device.getGraphicsQueue()));
        }
    }

    public void waitVulkan(long[] commandBuffers) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkSubmitInfo submitInfo = VkSubmitInfo.calloc((MemoryStack)stack).sType(4).pWaitSemaphores(stack.longs(this.vkSemaphoreHandle)).pWaitDstStageMask(stack.ints(65536)).pSignalSemaphores(null).pCommandBuffers(commandBuffers != null ? stack.pointers(commandBuffers) : null);
            VulkanUtils.VK_CHECK(VK11.vkQueueSubmit((VkQueue)this.device.getGraphicsQueue(), (VkSubmitInfo)submitInfo, (long)0L));
            VulkanUtils.VK_CHECK(VK11.vkQueueWaitIdle((VkQueue)this.device.getGraphicsQueue()));
        }
    }

    public void signalOpenGL(int[] textures, int[] framebuffers, int[] buffers) {
        EXTSemaphore.glSignalSemaphoreEXT((int)((int)this.glSemaphoreHandle), (int[])textures, (int[])framebuffers, (int[])buffers);
    }

    public void waitOpenGL(int[] textures, int[] framebuffers, int[] buffers) {
        EXTSemaphore.glWaitSemaphoreEXT((int)((int)this.glSemaphoreHandle), (int[])textures, (int[])framebuffers, (int[])buffers);
    }

    public void signalVulkan() {
        this.signalVulkan(null);
    }

    public void waitVulkan() {
        this.waitVulkan(null);
    }

    public void signalOpenGL() {
        this.signalOpenGL(null, null, null);
    }

    public void waitOpenGL() {
        this.waitOpenGL(null, null, null);
    }
}

