/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core;

import io.homo.superresolution.core.gui.core.MouseButton;
import io.homo.superresolution.core.gui.core.WidgetStyle;
import io.homo.superresolution.core.gui.core.animator.AnimationSet;
import io.homo.superresolution.core.gui.core.event.EventHandler;
import io.homo.superresolution.core.gui.core.event.EventListener;
import io.homo.superresolution.core.gui.core.event.GuiEventListener;
import io.homo.superresolution.core.gui.core.event.events.MouseEvent;
import io.homo.superresolution.core.gui.core.event.events.WidgetEvent;
import io.homo.superresolution.core.gui.core.impl.Renderable;
import io.homo.superresolution.core.gui.core.impl.TooltipHolder;
import io.homo.superresolution.core.gui.core.layout.AbstractLayoutElement;
import io.homo.superresolution.core.impl.Destroyable;
import java.util.Optional;
import java.util.function.Supplier;
import org.joml.Vector2f;

public abstract class AbstractWidget<T extends AbstractWidget<?, ?, ?>, STYLE extends WidgetStyle<?>, ANIM extends AnimationSet>
extends AbstractLayoutElement
implements GuiEventListener,
Renderable,
TooltipHolder,
Destroyable {
    protected boolean visible = true;
    protected boolean disabled = false;
    protected boolean hovered = false;
    protected boolean pressed = false;
    protected boolean focused = false;
    protected EventHandler eventHandler;
    protected STYLE style;
    protected ANIM animationSet;
    protected Supplier<Optional<String>> tooltipSupplier = Optional::empty;

    public AbstractWidget() {
        this.eventHandler = new EventHandler();
        this.init();
    }

    protected abstract void init();

    public STYLE style() {
        return this.style;
    }

    public T style(STYLE style) {
        this.style = style;
        return (T)this;
    }

    @Override
    public void mouseMove(float x, float y) {
        Vector2f mousePos = new Vector2f(x, y);
        boolean isHovering = this.getBounds().in(x, y);
        this.eventHandler.fire(new MouseEvent.MouseMoveEvent(mousePos));
        if (isHovering != this.hovered) {
            this.eventHandler.fire(new WidgetEvent.HoverEvent(mousePos, isHovering));
            this.setHovered(isHovering);
        }
    }

    @Override
    public void mousePress(float x, float y, int button) {
        if (this.getBounds().in(x, y)) {
            Vector2f mousePos = new Vector2f(x, y);
            if (button == MouseButton.Left.id()) {
                this.setPressed(true);
            }
            this.eventHandler.fire(new MouseEvent.MousePressEvent(mousePos, button));
        }
    }

    @Override
    public void mouseRelease(float x, float y, int button) {
        if (button == MouseButton.Left.id()) {
            Vector2f mousePos = new Vector2f(x, y);
            if (this.isPressed()) {
                this.eventHandler.fire(new MouseEvent.MouseReleaseEvent(mousePos, button));
            }
            this.setPressed(false);
        }
    }

    @Override
    public void mouseDrag(float mouseX, float mouseY, float dragX, float dragY, int button) {
        this.eventHandler.fire(new MouseEvent.MouseDragEvent(button, new Vector2f(mouseX, mouseY), new Vector2f(dragX, dragY)));
    }

    @Override
    public void mouseScroll(float x, float y, double scrollX) {
        this.eventHandler.fire(new MouseEvent.MouseScrollEvent(new Vector2f(x, y), (float)scrollX));
    }

    @Override
    public void keyPress(int keyCode, int scancode, int modifiers) {
        GuiEventListener.super.keyPress(keyCode, scancode, modifiers);
    }

    @Override
    public void keyRelease(int keyCode, int scancode, int modifiers) {
        GuiEventListener.super.keyRelease(keyCode, scancode, modifiers);
    }

    @Override
    public void charTyped(char codePoint, int modifiers) {
        GuiEventListener.super.charTyped(codePoint, modifiers);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public T setVisible(boolean visible) {
        if (visible == this.visible) {
            return (T)this;
        }
        this.visible = visible;
        return (T)this;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public T setHovered(boolean hovered) {
        if (hovered == this.hovered) {
            return (T)this;
        }
        this.hovered = hovered;
        if (!this.isVisible() || hovered) {
            // empty if block
        }
        return (T)this;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public T setFocused(boolean focused) {
        if (focused == this.focused) {
            return (T)this;
        }
        this.focused = focused;
        return (T)this;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public T setPressed(boolean pressed) {
        this.pressed = pressed;
        return (T)this;
    }

    public void onHover(EventListener<WidgetEvent.HoverEvent> listener) {
        this.eventHandler.on(WidgetEvent.HoverEvent.class, listener);
    }

    public void onFocus(EventListener<WidgetEvent.FocusEvent> listener) {
        this.eventHandler.on(WidgetEvent.FocusEvent.class, listener);
    }

    protected boolean isInteractive() {
        return false;
    }

    public AbstractWidget<?, ?, ?> findInteractiveWidgetAt(Vector2f absPos) {
        if (!this.hitTest(absPos)) {
            return null;
        }
        return this.isInteractive() ? this : null;
    }

    public void onMousePress(EventListener<MouseEvent.MousePressEvent> listener) {
        this.eventHandler.on(MouseEvent.MousePressEvent.class, listener);
    }

    public void onMouseMove(EventListener<MouseEvent.MouseMoveEvent> listener) {
        this.eventHandler.on(MouseEvent.MouseMoveEvent.class, listener);
    }

    public void onMouseRelease(EventListener<MouseEvent.MouseReleaseEvent> listener) {
        this.eventHandler.on(MouseEvent.MouseReleaseEvent.class, listener);
    }

    public void onMouseDrag(EventListener<MouseEvent.MouseDragEvent> listener) {
        this.eventHandler.on(MouseEvent.MouseDragEvent.class, listener);
    }

    public void onMouseScroll(EventListener<MouseEvent.MouseScrollEvent> listener) {
        this.eventHandler.on(MouseEvent.MouseScrollEvent.class, listener);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public AbstractWidget<T, STYLE, ANIM> setDisabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @Override
    public void setTooltipSupplier(Supplier<Optional<String>> supplier) {
        this.tooltipSupplier = supplier;
    }

    @Override
    public Optional<String> getTooltip() {
        return this.tooltipSupplier.get();
    }

    @Override
    public void setTooltip(String tooltip) {
        this.tooltipSupplier = () -> Optional.ofNullable(tooltip);
    }

    @Override
    public int getZIndex() {
        return this.style == null ? 0 : ((WidgetStyle)this.style).zIndex();
    }

    @Override
    public void destroy() {
    }
}

