/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core.animator;

import java.util.function.Function;

public class Easing {
    public static EasingMethod LINEAR = T -> T;
    public static EasingMethod EASE_IN_QUAD = T -> Float.valueOf(T.floatValue() * T.floatValue());
    public static EasingMethod EASE_OUT_QUAD = T -> Float.valueOf(T.floatValue() * (2.0f - T.floatValue()));
    public static EasingMethod EASE_IN_OUT_QUAD = T -> Float.valueOf((double)T.floatValue() < 0.5 ? 2.0f * T.floatValue() * T.floatValue() : -1.0f + (4.0f - 2.0f * T.floatValue()) * T.floatValue());
    public static EasingMethod EASE_IN_CUBIC = T -> Float.valueOf(T.floatValue() * T.floatValue() * T.floatValue());
    public static EasingMethod EASE_OUT_CUBIC = T -> {
        T = Float.valueOf(T.floatValue() - 1.0f);
        return Float.valueOf(T.floatValue() * T.floatValue() * T.floatValue() + 1.0f);
    };
    public static EasingMethod EASE_IN_OUT_CUBIC = T -> Float.valueOf((double)T.floatValue() < 0.5 ? 4.0f * T.floatValue() * T.floatValue() * T.floatValue() : (T.floatValue() - 1.0f) * (2.0f * T.floatValue() - 2.0f) * (2.0f * T.floatValue() - 2.0f) + 1.0f);
    public static EasingMethod EASE_IN_QUART = T -> Float.valueOf(T.floatValue() * T.floatValue() * T.floatValue() * T.floatValue());
    public static EasingMethod EASE_OUT_QUART = T -> {
        T = Float.valueOf(T.floatValue() - 1.0f);
        return Float.valueOf(1.0f - T.floatValue() * T.floatValue() * T.floatValue() * T.floatValue());
    };
    public static EasingMethod EASE_IN_OUT_QUART = T -> {
        float f;
        if ((double)T.floatValue() < 0.5) {
            f = 8.0f * T.floatValue() * T.floatValue() * T.floatValue() * T.floatValue();
        } else {
            T = Float.valueOf(T.floatValue() - 1.0f);
            f = 1.0f - 8.0f * T.floatValue() * T.floatValue() * T.floatValue() * T.floatValue();
        }
        return Float.valueOf(f);
    };
    public static EasingMethod EASE_IN_QUINT = T -> Float.valueOf(T.floatValue() * T.floatValue() * T.floatValue() * T.floatValue() * T.floatValue());
    public static EasingMethod EASE_OUT_QUINT = T -> {
        T = Float.valueOf(T.floatValue() - 1.0f);
        return Float.valueOf(1.0f + T.floatValue() * T.floatValue() * T.floatValue() * T.floatValue() * T.floatValue());
    };
    public static EasingMethod EASE_IN_OUT_QUINT = T -> {
        float f;
        if ((double)T.floatValue() < 0.5) {
            f = 16.0f * T.floatValue() * T.floatValue() * T.floatValue() * T.floatValue() * T.floatValue();
        } else {
            T = Float.valueOf(T.floatValue() - 1.0f);
            f = 1.0f + 16.0f * T.floatValue() * T.floatValue() * T.floatValue() * T.floatValue() * T.floatValue();
        }
        return Float.valueOf(f);
    };
    public static EasingMethod EASE_IN_BACK = x -> Float.valueOf(2.70158f * x.floatValue() * x.floatValue() * x.floatValue() - 1.70158f * x.floatValue() * x.floatValue());
    public static EasingMethod EASE_OUT_BACK = x -> Float.valueOf((float)(1.0 + (double)2.70158f * Math.pow(x.floatValue() - 1.0f, 3.0) + (double)1.70158f * Math.pow(x.floatValue() - 1.0f, 2.0)));

    public static EasingMethod cubicBezier(final float p1x, final float p1y, final float p2x, final float p2y) {
        return new EasingMethod(){

            @Override
            public Float apply(Float t) {
                float u = t.floatValue();
                for (int i = 0; i < 8; ++i) {
                    float x = this.bezierX(u, p1x, p2x);
                    float dx = this.bezierXDerivative(u, p1x, p2x);
                    if (Math.abs(dx) < 1.0E-6f) break;
                    u -= (x - t.floatValue()) / dx;
                    u = Math.max(0.0f, Math.min(1.0f, u));
                }
                float a = p1x * (1.0f - t.floatValue()) * (1.0f - t.floatValue()) * (1.0f - t.floatValue()) + 3.0f * p1y * t.floatValue() * ((1.0f - t.floatValue()) * (1.0f - t.floatValue())) + 3.0f * p2x * t.floatValue() * t.floatValue() * (1.0f - t.floatValue()) + p2y * t.floatValue() * t.floatValue() * t.floatValue();
                return Float.valueOf(this.bezierY(u, p1y, p2y));
            }

            private float bezierX(float t, float p1x2, float p2x2) {
                float u = 1.0f - t;
                return 3.0f * u * u * t * p1x2 + 3.0f * u * t * t * p2x2 + t * t * t;
            }

            private float bezierY(float t, float p1y2, float p2y2) {
                float u = 1.0f - t;
                return 3.0f * u * u * t * p1y2 + 3.0f * u * t * t * p2y2 + t * t * t;
            }

            private float bezierXDerivative(float t, float p1x2, float p2x2) {
                float u = 1.0f - t;
                return 3.0f * u * u * p1x2 + 6.0f * u * t * (p2x2 - p1x2) + 3.0f * t * t * (1.0f - p2x2);
            }
        };
    }

    public static interface EasingMethod
    extends Function<Float, Float> {
    }
}

