/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core.animator;

import io.homo.superresolution.core.gui.core.animator.Easing;
import io.homo.superresolution.core.gui.core.animator.IAnimator;
import java.util.function.Consumer;

public class NumberAnimator
implements IAnimator<Number> {
    private double currentValue;
    private double targetValue;
    private long duration;
    private long startTime;
    private boolean running = false;
    private boolean reset = false;
    private Easing.EasingMethod easingMethod;
    private Runnable onCompleteCallback;
    private Consumer<Number> onUpdateCallback;
    private long delay;
    private long delayStartTime;
    private IAnimator.AnimationState state = IAnimator.AnimationState.IDLE;

    public NumberAnimator() {
        this.easingMethod = Easing.LINEAR;
    }

    @Override
    public IAnimator<Number> animateTo(Number target, long duration, boolean reset) {
        this.targetValue = target.doubleValue();
        this.duration = duration;
        this.reset = reset;
        this.state = IAnimator.AnimationState.RUNNING;
        this.startTime = System.currentTimeMillis();
        this.running = true;
        this.delay = 0L;
        return this;
    }

    @Override
    public IAnimator<Number> animateTo(Number target, long duration) {
        return this.animateTo(target, duration, false);
    }

    @Override
    public IAnimator<Number> smoothUpdateTo(Number target, long duration) {
        return this.animateTo(target, duration, false);
    }

    @Override
    public IAnimator<Number> set(Number value) {
        this.currentValue = value.doubleValue();
        return this;
    }

    @Override
    public IAnimator<Number> delay(long delayMs) {
        this.delay = delayMs;
        this.delayStartTime = System.currentTimeMillis();
        return this;
    }

    @Override
    public IAnimator<Number> ease(Easing.EasingMethod easing) {
        this.easingMethod = easing;
        return this;
    }

    @Override
    public IAnimator<Number> onComplete(Runnable callback) {
        this.onCompleteCallback = callback;
        return this;
    }

    @Override
    public IAnimator<Number> onUpdate(Consumer<Number> callback) {
        this.onUpdateCallback = callback;
        return this;
    }

    @Override
    public float progress() {
        if (this.state == IAnimator.AnimationState.RUNNING) {
            long currentTime = System.currentTimeMillis();
            if (this.delay > 0L && currentTime - this.delayStartTime < this.delay) {
                return 0.0f;
            }
            double progress = (double)(currentTime - this.startTime) / (double)this.duration;
            return (float)progress;
        }
        return this.state == IAnimator.AnimationState.IDLE ? 0.0f : 1.0f;
    }

    @Override
    public void update() {
        if (this.state == IAnimator.AnimationState.RUNNING) {
            long currentTime = System.currentTimeMillis();
            if (this.delay > 0L && currentTime - this.delayStartTime < this.delay) {
                return;
            }
            double progress = (double)(currentTime - this.startTime) / (double)this.duration;
            if (progress >= 1.0) {
                this.currentValue = this.targetValue;
                this.state = IAnimator.AnimationState.COMPLETED;
                if (this.onCompleteCallback != null) {
                    this.onCompleteCallback.run();
                }
                this.running = false;
            } else {
                progress = Math.min(1.0, Math.max(0.0, progress));
                this.currentValue = (double)((Float)this.easingMethod.apply(Float.valueOf((float)progress))).floatValue() * (this.targetValue - this.currentValue) + this.currentValue;
                if (this.onUpdateCallback != null) {
                    this.onUpdateCallback.accept(this.currentValue);
                }
            }
        }
    }

    @Override
    public IAnimator<Number> reverse() {
        double temp = this.targetValue;
        this.targetValue = this.currentValue;
        this.currentValue = temp;
        this.startTime = System.currentTimeMillis();
        this.state = IAnimator.AnimationState.RUNNING;
        this.running = true;
        return this;
    }

    @Override
    public void cancel() {
        this.state = IAnimator.AnimationState.IDLE;
        this.running = false;
    }

    @Override
    public void reset() {
        this.state = IAnimator.AnimationState.IDLE;
        this.running = false;
        this.currentValue = 0.0;
    }

    @Override
    public Number value() {
        return this.currentValue;
    }

    @Override
    public Number targetValue() {
        return this.targetValue;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean isCompleted() {
        return this.state == IAnimator.AnimationState.COMPLETED;
    }

    public int intValue() {
        return this.value().intValue();
    }

    public long longValue() {
        return this.value().longValue();
    }

    public float floatValue() {
        return this.value().floatValue();
    }

    public double doubleValue() {
        return this.value().doubleValue();
    }
}

