/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core.backends.nanovg;

import io.homo.superresolution.core.gui.core.backends.interfaces.IFont;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVG;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;

public class NanoVGFont
implements IFont {
    public int id = -1;
    public String name;
    public String path;

    public NanoVGFont(String name, String path) {
        this.name = name;
        this.path = path;
    }

    public void load() {
        try {
            Path tempFile = Files.createTempFile("grapheneui-font-" + String.valueOf(UUID.randomUUID()), ".ttf", new FileAttribute[0]);
            InputStream fontStream = this.getClass().getResourceAsStream(this.path);
            if (fontStream == null) {
                throw new RuntimeException("\u5b57\u4f53\u8def\u5f84\u4e0d\u5b58\u5728: " + this.path);
            }
            Files.copy(fontStream, tempFile, StandardCopyOption.REPLACE_EXISTING);
            fontStream.close();
            this.id = org.lwjgl.nanovg.NanoVG.nvgCreateFont((long)NanoVG.context.contextPtr, (CharSequence)this.name, (CharSequence)tempFile.toString());
            tempFile.toFile().delete();
        }
        catch (Exception e) {
            throw new RuntimeException("\u5b57\u4f53\u52a0\u8f7d\u5931\u8d25: " + this.name, e);
        }
    }
}

