/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.forge.platform;

import io.homo.superresolution.api.platform.EnvironmentType;
import io.homo.superresolution.api.platform.Platform;
import io.homo.superresolution.forge.platform.IrisForgePlatform;
import java.nio.file.Path;
import net.minecraft.SharedConstants;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;

public class ForgePlatform
extends Platform {
    @Override
    public void init() {
        if (this.isInstallIris()) {
            this.irisPlatform = new IrisForgePlatform();
        }
    }

    @Override
    public String getMinecraftVersion() {
        return SharedConstants.m_183709_().m_132493_();
    }

    @Override
    public boolean isModLoaded(String modId) {
        return LoadingModList.get().getModFileById(modId) != null;
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public String getModVersionString(String modId) {
        if (this.isModLoaded(modId)) {
            return ModList.get().getModFileById(modId).versionString();
        }
        return null;
    }

    @Override
    public EnvironmentType getEnv() {
        return switch (FMLLoader.getDist()) {
            default -> throw new IncompatibleClassChangeError();
            case Dist.CLIENT -> EnvironmentType.CLIENT;
            case Dist.DEDICATED_SERVER -> EnvironmentType.SERVER;
        };
    }

    @Override
    public Path getGameFolder() {
        return FMLPaths.GAMEDIR.get();
    }
}

