/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.icyllis.modernui.animation;

import io.homo.superresolution.thirdparty.icyllis.modernui.animation.AnimationHandler;
import io.homo.superresolution.thirdparty.icyllis.modernui.animation.ColorEvaluator;
import io.homo.superresolution.thirdparty.icyllis.modernui.animation.PropertyValuesHolder;
import io.homo.superresolution.thirdparty.icyllis.modernui.animation.TypeConverter;
import io.homo.superresolution.thirdparty.icyllis.modernui.animation.TypeEvaluator;
import io.homo.superresolution.thirdparty.icyllis.modernui.animation.ValueAnimator;
import io.homo.superresolution.thirdparty.icyllis.modernui.util.FloatProperty;
import io.homo.superresolution.thirdparty.icyllis.modernui.util.IntProperty;
import io.homo.superresolution.thirdparty.icyllis.modernui.util.Property;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ObjectAnimator
extends ValueAnimator {
    @Nullable
    private WeakReference<Object> mTarget;
    private boolean mAutoCancel = false;

    @Nonnull
    public static <T> ObjectAnimator ofInt(@Nullable T target, @Nonnull IntProperty<T> property, int ... values) {
        return ObjectAnimator.ofPropertyValuesHolder(target, PropertyValuesHolder.ofInt(property, values));
    }

    @Nonnull
    public static <T> ObjectAnimator ofArgb(@Nullable T target, @Nonnull IntProperty<T> property, int ... values) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofInt(property, values);
        pvh.setEvaluator(ColorEvaluator.getInstance());
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    @Nonnull
    public static <T> ObjectAnimator ofFloat(@Nullable T target, @Nonnull FloatProperty<T> property, float ... values) {
        return ObjectAnimator.ofPropertyValuesHolder(target, PropertyValuesHolder.ofFloat(property, values));
    }

    @Nonnull
    @SafeVarargs
    public static <T, V> ObjectAnimator ofObject(@Nullable T target, @Nonnull Property<T, V> property, @Nonnull TypeEvaluator<V> evaluator, V ... values) {
        return ObjectAnimator.ofPropertyValuesHolder(target, PropertyValuesHolder.ofObject(property, evaluator, values));
    }

    @Nonnull
    @SafeVarargs
    public static <T, V, P> ObjectAnimator ofObject(@Nullable T target, @Nonnull Property<T, P> property, @Nonnull TypeConverter<V, P> converter, @Nonnull TypeEvaluator<V> evaluator, V ... values) {
        return ObjectAnimator.ofPropertyValuesHolder(target, PropertyValuesHolder.ofObject(property, converter, evaluator, values));
    }

    @Nonnull
    public static ObjectAnimator ofPropertyValuesHolder(@Nullable Object target, PropertyValuesHolder ... values) {
        ObjectAnimator anim = new ObjectAnimator();
        anim.setTarget(target);
        anim.setValues(values);
        return anim;
    }

    public void setAutoCancel(boolean cancel) {
        this.mAutoCancel = cancel;
    }

    @Override
    public void start() {
        AnimationHandler.getInstance().autoCancelBasedOn(this);
        super.start();
    }

    @Override
    public ObjectAnimator clone() {
        return (ObjectAnimator)super.clone();
    }

    @Override
    public void setupStartValues() {
        this.initAnimation();
        Object target = this.getTarget();
        if (target != null) {
            for (PropertyValuesHolder value : this.mValues) {
                value.setupStartValue(target);
            }
        }
    }

    @Override
    public void setupEndValues() {
        this.initAnimation();
        Object target = this.getTarget();
        if (target != null) {
            for (PropertyValuesHolder value : this.mValues) {
                value.setupEndValue(target);
            }
        }
    }

    @Override
    void initAnimation() {
        if (!this.mInitialized) {
            Object target = this.getTarget();
            for (PropertyValuesHolder value : this.mValues) {
                if (target != null) {
                    value.setupSetterAndGetter(target);
                }
                value.init();
            }
            this.mInitialized = true;
        }
    }

    @Override
    public ObjectAnimator setDuration(long duration) {
        super.setDuration(duration);
        return this;
    }

    @Nullable
    public Object getTarget() {
        return this.mTarget == null ? null : this.mTarget.get();
    }

    @Override
    public void setTarget(@Nullable Object target) {
        Object oldTarget = this.getTarget();
        if (oldTarget != target) {
            if (this.isStarted()) {
                this.cancel();
            }
            this.mTarget = target == null ? null : new WeakReference<Object>(target);
            this.mInitialized = false;
        }
    }

    @Override
    void animateValue(float fraction) {
        Object target = this.getTarget();
        if (this.mTarget != null && target == null) {
            this.cancel();
            return;
        }
        super.animateValue(fraction);
        if (target != null) {
            for (PropertyValuesHolder value : this.mValues) {
                value.setAnimatedValue(target);
            }
        }
    }

    boolean shouldAutoCancel(AnimationHandler.FrameCallback anim) {
        if (anim == this && this.mAutoCancel) {
            return true;
        }
        if (anim instanceof ObjectAnimator) {
            ObjectAnimator it = (ObjectAnimator)anim;
            if (it.mAutoCancel) {
                PropertyValuesHolder[] itsValues = it.getValues();
                if (it.getTarget() == this.getTarget() && this.mValues.length == itsValues.length) {
                    for (int i = 0; i < this.mValues.length; ++i) {
                        if (Objects.equals(this.mValues[i], itsValues[i])) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ObjectAnimator@" + Integer.toHexString(this.hashCode()) + ", target " + String.valueOf(this.getTarget()));
        if (this.mValues != null) {
            for (PropertyValuesHolder value : this.mValues) {
                sb.append("\n    ").append(value.toString());
            }
        }
        return sb.toString();
    }
}

