/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.icyllis.modernui.core;

import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.thirdparty.icyllis.modernui.annotation.NonNull;
import io.homo.superresolution.thirdparty.icyllis.modernui.annotation.Nullable;
import io.homo.superresolution.thirdparty.icyllis.modernui.core.Core;
import io.homo.superresolution.thirdparty.icyllis.modernui.core.Message;
import io.homo.superresolution.thirdparty.icyllis.modernui.core.MessageQueue;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class Looper {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"Looper");
    static final ThreadLocal<Looper> sThreadLocal = new ThreadLocal();
    private static volatile Looper sMainLooper;
    private static volatile Looper sFrameLooper;
    private static volatile Observer sObserver;
    final MessageQueue mQueue;
    final Thread mThread = Thread.currentThread();
    private boolean mInLoop;
    private long mSlowDispatchThresholdMs;
    private long mSlowDeliveryThresholdMs;
    private boolean mSlowDeliveryDetected;

    @NonNull
    public static Looper prepare() {
        if (sThreadLocal.get() != null) {
            throw new RuntimeException("Only one Looper may be created per thread");
        }
        Looper looper = new Looper(false);
        sThreadLocal.set(looper);
        return looper;
    }

    public static void initFrameLooper() {
        Looper looper;
        sFrameLooper = looper = Looper.prepare();
    }

    @ApiStatus.Internal
    public static void prepareMainLooper() {
        if (sMainLooper != null) {
            throw new IllegalStateException();
        }
        Looper me = new Looper(true);
        sThreadLocal.set(me);
        sMainLooper = me;
    }

    public static Looper getMainLooper() {
        return sMainLooper;
    }

    public static void setObserver(@Nullable Observer observer) {
        sObserver = observer;
    }

    public static boolean poll(@NonNull Looper me) {
        long dispatchEnd;
        Message msg = me.mQueue.next();
        if (msg == null) {
            return false;
        }
        Observer observer = sObserver;
        long slowDispatchThresholdMs = me.mSlowDispatchThresholdMs;
        long slowDeliveryThresholdMs = me.mSlowDeliveryThresholdMs;
        boolean logSlowDelivery = slowDeliveryThresholdMs > 0L && msg.when > 0L;
        boolean logSlowDispatch = slowDispatchThresholdMs > 0L;
        long dispatchStart = logSlowDelivery || logSlowDispatch ? Core.timeMillis() : 0L;
        Object token = observer == null ? null : observer.messageDispatchStarting();
        try {
            msg.target.dispatchMessage(msg);
            if (observer != null) {
                observer.messageDispatched(token, msg);
            }
            dispatchEnd = logSlowDispatch ? Core.timeMillis() : 0L;
        }
        catch (Exception exception) {
            if (observer != null) {
                observer.dispatchingThrewException(token, msg, exception);
            }
            throw exception;
        }
        if (logSlowDelivery) {
            if (me.mSlowDeliveryDetected) {
                if (dispatchStart - msg.when <= 10L) {
                    SuperResolution.LOGGER.warn(MARKER, "Drained");
                    me.mSlowDeliveryDetected = false;
                }
            } else if (Looper.showSlowLog(slowDeliveryThresholdMs, msg.when, dispatchStart, "delivery", msg)) {
                me.mSlowDeliveryDetected = true;
            }
        }
        if (logSlowDispatch) {
            Looper.showSlowLog(slowDispatchThresholdMs, dispatchStart, dispatchEnd, "dispatch", msg);
        }
        msg.recycleUnchecked();
        return true;
    }

    public static void loop() {
        Looper me = Looper.myLooper();
        if (me == null) {
            throw new RuntimeException("No Looper; Looper.prepare() wasn't called on this thread.");
        }
        if (me.mInLoop) {
            SuperResolution.LOGGER.warn(MARKER, "Loop again would have the queued messages be executed before this one completed.");
        }
        me.mInLoop = true;
        me.mSlowDeliveryDetected = false;
        while (Looper.poll(me)) {
        }
    }

    private static boolean showSlowLog(long threshold, long measureStart, long measureEnd, String what, Message msg) {
        long actualTime = measureEnd - measureStart;
        if (actualTime < threshold) {
            return false;
        }
        SuperResolution.LOGGER.warn(MARKER, "Slow {} took {}ms {} h={} c={} m={}", new Object[]{what, actualTime, Thread.currentThread().getName(), msg.target.getClass().getName(), msg.callback, msg.what});
        return true;
    }

    @Nullable
    public static Looper myLooper() {
        return sThreadLocal.get();
    }

    @Nullable
    public static Looper getFrameLooper() {
        return sFrameLooper;
    }

    @NonNull
    public static MessageQueue myQueue() {
        return Looper.sThreadLocal.get().mQueue;
    }

    private Looper(boolean main) {
        this.mQueue = new MessageQueue(main ? null : this.mThread);
    }

    public boolean isCurrentThread() {
        return Thread.currentThread() == this.mThread;
    }

    public void setSlowLogThresholdMs(long slowDispatchThresholdMs, long slowDeliveryThresholdMs) {
        this.mSlowDispatchThresholdMs = slowDispatchThresholdMs;
        this.mSlowDeliveryThresholdMs = slowDeliveryThresholdMs;
    }

    public void quit() {
        this.mQueue.quit(false);
    }

    public void quitSafely() {
        this.mQueue.quit(true);
    }

    @NonNull
    public Thread getThread() {
        return this.mThread;
    }

    @NonNull
    public MessageQueue getQueue() {
        return this.mQueue;
    }

    @NonNull
    public String toString() {
        return "Looper (" + this.mThread.getName() + ", tid " + this.mThread.getId() + ") {" + Integer.toHexString(System.identityHashCode(this)) + "}";
    }

    public static interface Observer {
        public Object messageDispatchStarting();

        public void messageDispatched(Object var1, Message var2);

        public void dispatchingThrewException(Object var1, Message var2, Exception var3);
    }
}

