/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric.Comparison;

public class FloatOptional {
    private static final FloatOptional UNDEFINED = new FloatOptional();
    private final float value;

    private FloatOptional() {
        this.value = Float.NaN;
    }

    private FloatOptional(float value) {
        this.value = value;
    }

    public static FloatOptional of() {
        return UNDEFINED;
    }

    public static FloatOptional of(float value) {
        if (Float.isNaN(value)) {
            return UNDEFINED;
        }
        return new FloatOptional(value);
    }

    public float unwrap() {
        return this.value;
    }

    public float unwrapOrDefault(float defaultValue) {
        return this.isUndefined() ? defaultValue : this.value;
    }

    public boolean isUndefined() {
        return Comparison.isUndefined(this.value);
    }

    public boolean isDefined() {
        return Comparison.isDefined(this.value);
    }

    public FloatOptional add(FloatOptional other) {
        return FloatOptional.of(this.value + other.value);
    }

    public boolean inexactEquals(FloatOptional other) {
        return Comparison.inexactEquals(this.value, other.value);
    }

    public FloatOptional maxOrDefined(FloatOptional other) {
        return FloatOptional.of(Comparison.maxOrDefined(this.value, other.value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatOptional that = (FloatOptional)o;
        if (this.isUndefined() && that.isUndefined()) {
            return true;
        }
        return Float.compare(this.value, that.value) == 0;
    }

    public int hashCode() {
        return this.isUndefined() ? 0 : Float.floatToIntBits(this.value);
    }

    public int compareTo(FloatOptional other) {
        return Float.compare(this.value, other.value);
    }

    public boolean isGreaterThan(FloatOptional other) {
        return this.unwrap() > other.unwrap();
    }

    public boolean isLessThan(FloatOptional other) {
        return this.unwrap() < other.unwrap();
    }

    public boolean isGreaterThanOrEqual(FloatOptional other) {
        return this.isGreaterThan(other) || this.equals(other);
    }

    public boolean isLessThanOrEqual(FloatOptional other) {
        return this.isLessThan(other) || this.equals(other);
    }

    public float getValue() {
        return this.value;
    }

    public String toString() {
        if (this.isUndefined()) {
            return "undefined";
        }
        return String.valueOf(this.value);
    }
}

