/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style;

import java.util.BitSet;

public class SmallValueBuffer {
    private int count = 0;
    private int[] buffer = new int[16];
    private final BitSet wideElements = new BitSet();
    private static final int INITIAL_CAPACITY = 16;

    public short push(int value) {
        int index = this.count++;
        assert (index < 4096) : "SmallValueBuffer can only hold up to 4096 chunks";
        this.ensureCapacity(index);
        this.buffer[index] = value;
        return (short)index;
    }

    public short push(long value) {
        int lsb = (int)(value & 0xFFFFFFFFL);
        int msb = (int)(value >>> 32);
        short lsbIndex = this.push(lsb);
        short msbIndex = this.push(msb);
        assert (msbIndex < 4096) : "SmallValueBuffer can only hold up to 4096 chunks";
        this.wideElements.set(lsbIndex);
        return lsbIndex;
    }

    public short replace(short index, int value) {
        this.ensureCapacity(index);
        this.buffer[index] = value;
        return index;
    }

    public short replace(short index, long value) {
        boolean isWide = this.wideElements.get(index);
        if (isWide) {
            int lsb = (int)(value & 0xFFFFFFFFL);
            int msb = (int)(value >>> 32);
            this.replace(index, lsb);
            this.replace((short)(index + 1), msb);
            return index;
        }
        return this.push(value);
    }

    public int get32(short index) {
        if (index >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.count);
        }
        return this.buffer[index];
    }

    public long get64(short index) {
        long lsb = (long)this.get32(index) & 0xFFFFFFFFL;
        long msb = (long)this.get32((short)(index + 1)) & 0xFFFFFFFFL;
        return msb << 32 | lsb;
    }

    private void ensureCapacity(int index) {
        if (index >= this.buffer.length) {
            int newCapacity = Math.max(this.buffer.length * 2, index + 1);
            newCapacity = Math.min(newCapacity, 4096);
            int[] newBuffer = new int[newCapacity];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
    }
}

