/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.dataset;

import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import io.homo.superresolution.api.event.LevelRenderEndEvent;
import io.homo.superresolution.api.event.LevelRenderStartEvent;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.CopyOperation;
import io.homo.superresolution.core.graphics.impl.buffer.BufferDescription;
import io.homo.superresolution.core.graphics.impl.buffer.BufferUsage;
import io.homo.superresolution.core.graphics.impl.buffer.IBuffer;
import io.homo.superresolution.core.graphics.impl.buffer.IBufferData;
import io.homo.superresolution.core.graphics.impl.buffer.UniformStructBuilder;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.pipeline.Pipeline;
import io.homo.superresolution.core.graphics.impl.shader.IShaderProgram;
import io.homo.superresolution.core.graphics.impl.shader.ShaderDescription;
import io.homo.superresolution.core.graphics.impl.shader.ShaderSource;
import io.homo.superresolution.core.graphics.impl.shader.ShaderType;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.graphics.opengl.texture.GlTexture2D;
import io.homo.superresolution.core.graphics.opengl.utils.GlTextureCopier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.lwjgl.opengl.GL33;
import org.lwjgl.system.MemoryUtil;

public class DataSetGenerator {
    public static File OUTPUT_DIR = Paths.get("K:/", "msrDataset").toFile();
    private static final class_304 SAVE_KEYMAPPING = new class_304("key.super_resolution.save_data", class_3675.class_307.field_1668, 296, "Super Resolution");
    private static ITexture tempColorTexture;
    private static ITexture tempDepthTexture;
    private static IFrameBuffer preprocessDepthFrameBuffer;
    private static Pipeline depthPreprocessPipeline;
    private static IShaderProgram<?> depthPreprocessShader;
    private static IBufferData depthPreprocessConfigData;
    private static IBuffer depthPreprocessConfigUBO;
    private static String id;
    private static String previousId;

    public static void init() {
        KeyMappingRegistry.register((class_304)SAVE_KEYMAPPING);
        LevelRenderStartEvent.EVENT.register(DataSetGenerator::onLevelBegin);
        LevelRenderEndEvent.EVENT.register(DataSetGenerator::onLevelEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeImage(ITexture texture, String path) {
        Path outputPath = Paths.get(path, new String[0]);
        try {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to create parent directories for: " + path);
            e.printStackTrace();
            return;
        }
        int width = texture.getWidth();
        int height = texture.getHeight();
        TextureFormat format = texture.getTextureFormat();
        int bytesPerPixel = format.getBytesPerPixel();
        int dataSize = width * height * bytesPerPixel;
        ByteBuffer pixelData = MemoryUtil.memCalloc((int)dataSize);
        boolean success = DataSetGenerator.readPixels(texture, pixelData, 0, dataSize);
        if (!success) {
            System.err.println("Failed to read pixel data from texture");
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(outputPath.toFile());){
            GzipParameters parm = new GzipParameters();
            parm.setCompressionLevel(1);
            byte[] arr = new byte[dataSize];
            pixelData.get(arr);
            fos.write(arr);
        }
        catch (IOException e) {
            System.err.println("Failed to write texture data to file: " + path);
            e.printStackTrace();
        }
        finally {
            MemoryUtil.memFree((Buffer)pixelData);
        }
    }

    private static void onLevelBegin() {
        File dir;
        int frameCount = RenderHandlerManager.getFrameCount();
        if (!SAVE_KEYMAPPING.method_1434()) {
            previousId = id;
            return;
        }
        OUTPUT_DIR = Paths.get((String)SuperResolutionConfig.DATASET_PATH.get(), new String[0]).toFile();
        if (!OUTPUT_DIR.exists() && !OUTPUT_DIR.mkdirs()) {
            System.err.println("Failed to create output directory: " + OUTPUT_DIR.getAbsolutePath());
        }
        if (!(dir = Paths.get(OUTPUT_DIR.getPath(), new String[0]).toFile()).exists() && !dir.mkdirs()) {
            System.err.println("Failed to create frame output directory: " + dir.getAbsolutePath());
        }
        if (tempColorTexture == null) {
            tempColorTexture = GlTexture2D.create(TextureDescription.create().size(1, 1).type(TextureType.Texture2D).mipmapsDisabled().usages(TextureUsages.create().sampler()).format(TextureFormat.RGB16F).build());
        }
        tempColorTexture.resize(RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight());
        if (tempDepthTexture == null) {
            tempDepthTexture = GlTexture2D.create(TextureDescription.create().size(1, 1).type(TextureType.Texture2D).mipmapsDisabled().usages(TextureUsages.create().sampler()).format(TextureFormat.R32F).build());
        }
        tempDepthTexture.resize(RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight());
        if (preprocessDepthFrameBuffer == null) {
            preprocessDepthFrameBuffer = GlFrameBuffer.create(tempDepthTexture, null);
        }
        if (depthPreprocessConfigData == null) {
            depthPreprocessConfigData = UniformStructBuilder.start().floatEntry("near").floatEntry("far").build();
        }
        if (depthPreprocessConfigUBO == null) {
            depthPreprocessConfigUBO = RenderSystems.current().device().createBuffer(BufferDescription.create().size(depthPreprocessConfigData.size()).usage(BufferUsage.Ubo).build());
            depthPreprocessConfigUBO.setBufferData(depthPreprocessConfigData);
        }
        if (depthPreprocessShader == null) {
            depthPreprocessShader = RenderSystems.current().device().createShaderProgram(ShaderDescription.graphics(new ShaderSource(ShaderType.Fragment, "/shader/preprocess_depth.frag.glsl", true), new ShaderSource(ShaderType.Vertex, "/shader/preprocess_depth.vert.glsl", true)).name("SRPreprocessDepthShader").uniformBuffer("camera_config", 0, (int)depthPreprocessConfigData.size()).uniformSamplerTexture("tex", 0).build());
            depthPreprocessShader.compile();
        }
        previousId = id;
        id = UUID.randomUUID().toString().replace("-", "");
    }

    private static String getTextureName(ITexture texture, String desc, String id, String previousId) {
        if (desc.contains("Depth")) {
            return "%s-%s_%s-%s_%s.%s+%s!%s_%s.texture.bin".formatted(desc, texture.getWidth(), texture.getHeight(), texture.getTextureFormat().name(), texture.getTextureFormat().getChannelCount(), id, previousId, "0.05", String.valueOf(class_310.method_1551().field_1773.method_32796()));
        }
        return "%s-%s_%s-%s_%s.%s+%s.texture.bin".formatted(desc, texture.getWidth(), texture.getHeight(), texture.getTextureFormat().name(), texture.getTextureFormat().getChannelCount(), id, previousId);
    }

    private static void onLevelEnd() {
        int frameCount = RenderHandlerManager.getFrameCount();
        if (!SAVE_KEYMAPPING.method_1434()) {
            previousId = id;
            return;
        }
        File dir = Paths.get(OUTPUT_DIR.getPath(), new String[0]).toFile();
        File HR_RGB_IMAGE = Paths.get(dir.getPath(), DataSetGenerator.getTextureName(tempColorTexture, "Color", id, previousId)).toFile();
        GlTextureCopier.copy(CopyOperation.create().src(RenderHandlerManager.getColorTexture()).dst(tempColorTexture).fromTo(CopyOperation.TextureChancel.R, CopyOperation.TextureChancel.R).fromTo(CopyOperation.TextureChancel.G, CopyOperation.TextureChancel.G).fromTo(CopyOperation.TextureChancel.B, CopyOperation.TextureChancel.B));
        DataSetGenerator.writeImage(tempColorTexture, HR_RGB_IMAGE.getAbsolutePath());
        SuperResolution.LOGGER.info("\u5199\u5165{}", (Object)HR_RGB_IMAGE.getAbsolutePath());
        File HR_DEPTH_IMAGE = Paths.get(dir.getPath(), DataSetGenerator.getTextureName(tempDepthTexture, "Depth", id, previousId)).toFile();
        DataSetGenerator.writeImage(RenderHandlerManager.getDepthTexture(), HR_DEPTH_IMAGE.getAbsolutePath());
        SuperResolution.LOGGER.info("\u5199\u5165{}", (Object)HR_DEPTH_IMAGE.getAbsolutePath());
    }

    private static int getGLPixelFormat(TextureFormat format) {
        return switch (format) {
            default -> throw new IncompatibleClassChangeError();
            case TextureFormat.RGBA8, TextureFormat.RGBA16F, TextureFormat.RGBA16 -> 6408;
            case TextureFormat.RGB8, TextureFormat.R11G11B10F, TextureFormat.RGB16F -> 6407;
            case TextureFormat.RG8, TextureFormat.RG16F, TextureFormat.RG32F -> 33319;
            case TextureFormat.R8, TextureFormat.R16F, TextureFormat.R32F, TextureFormat.R32UI, TextureFormat.R16_SNORM, TextureFormat.DEPTH32F, TextureFormat.DEPTH24_STENCIL8, TextureFormat.DEPTH24, TextureFormat.DEPTH32, TextureFormat.DEPTH_COMPONENT, TextureFormat.DEPTH32F_STENCIL8 -> 6403;
        };
    }

    private static int getGLPixelType(TextureFormat format) {
        return switch (format) {
            default -> throw new IncompatibleClassChangeError();
            case TextureFormat.RGBA16F, TextureFormat.RGB16F, TextureFormat.RG16F, TextureFormat.R16F, TextureFormat.R16_SNORM -> 5131;
            case TextureFormat.RGBA8, TextureFormat.RGBA16, TextureFormat.RGB8, TextureFormat.RG8, TextureFormat.R8, TextureFormat.DEPTH24, TextureFormat.DEPTH32, TextureFormat.DEPTH_COMPONENT -> 5121;
            case TextureFormat.RG32F, TextureFormat.R32F, TextureFormat.DEPTH32F, TextureFormat.DEPTH32F_STENCIL8 -> 5126;
            case TextureFormat.R32UI -> 5125;
            case TextureFormat.DEPTH24_STENCIL8 -> 34042;
            case TextureFormat.R11G11B10F -> 35899;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean readPixels(ITexture texture, ByteBuffer buffer, int offset, int length) {
        GlFrameBuffer temp = GlFrameBuffer.create(texture, null, texture.getWidth(), texture.getHeight());
        GL33.glBindFramebuffer((int)36160, (int)((int)temp.handle()));
        GL33.glPixelStorei((int)3333, (int)1);
        int pixelFormat = DataSetGenerator.getGLPixelFormat(texture.getTextureFormat());
        int pixelType = DataSetGenerator.getGLPixelType(texture.getTextureFormat());
        try {
            GL33.glReadPixels((int)0, (int)0, (int)texture.getWidth(), (int)texture.getHeight(), (int)pixelFormat, (int)pixelType, (ByteBuffer)buffer);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.err.println("Failed to read pixels from texture");
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            temp.destroy();
        }
    }

    static {
        id = UUID.randomUUID().toString().replace("-", "");
    }
}

