/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.platform.win32.Kernel32;
import io.homo.superresolution.api.platform.OperatingSystem;
import io.homo.superresolution.api.platform.OperatingSystemType;
import io.homo.superresolution.api.platform.SystemArchitecture;
import io.homo.superresolution.core.utils.MessageBox;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.system.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibManager {
    public static final String BASE_PATH = "lib";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SuperResolution-NativeLib");
    public static final boolean USE_DEBUG_LIB = true;
    private static final List<NativeLib> libs = new ArrayList<NativeLib>();
    private static boolean nativeApiAvailable;
    public static NativeLib LIB_SUPER_RESOLUTION;
    public static NativeLib LIB_NANOVG;
    public static NativeLib LIB_SUPER_RESOLUTION_FSR;
    public static NativeLib LIB_SUPER_RESOLUTION_XESS;
    public static NativeLib LIB_SUPER_RESOLUTION_FSRGL;
    private static ExtendedKernel32 kernel32Instance;

    public static boolean nativeApiAvailable() {
        return nativeApiAvailable;
    }

    public static void extract(String path) {
        LOGGER.info("\u5f00\u59cb\u63d0\u53d6\u4f9d\u8d56\u5e93\u6587\u4ef6");
        boolean status = true;
        String error = null;
        try {
            for (NativeLib lib : libs) {
                if (NativeLibManager.extractLibrary(path, lib)) continue;
                status = false;
            }
        }
        catch (Exception e) {
            status = false;
            error = e.toString();
            e.printStackTrace();
        }
        if (!status) {
            LOGGER.error("\u4f9d\u8d56\u5e93\u63d0\u53d6\u5931\u8d25; \u4fe1\u606f: {}", (Object)(error != null ? error : "\u65e0"));
            MessageBox.createError("SuperResolution\u5728\u63d0\u53d6\u5fc5\u8981\u4f9d\u8d56\u5e93\u65f6\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s".formatted(error), "Error");
            throw new RuntimeException("\u4f9d\u8d56\u5e93\u63d0\u53d6\u5931\u8d25");
        }
        LOGGER.info("\u4f9d\u8d56\u5e93\u6587\u4ef6\u5df2\u63d0\u53d6\u5230 {}", (Object)path);
    }

    public static void load(String path) {
        for (NativeLib lib : libs) {
            File f = lib.getTargetPath(Path.of(path, new String[0])).toFile();
            if (!lib.loadAtStartup) continue;
            LOGGER.info("\u52a0\u8f7d\u4f9d\u8d56\u5e93\uff1a {}", (Object)f.getAbsolutePath());
            System.load(f.getAbsolutePath());
        }
        nativeApiAvailable = true;
    }

    private static boolean _writeFile(InputStream in, String path) throws IOException {
        if (in == null) {
            return false;
        }
        Path filePath = Path.of(path, new String[0]);
        Files.copy(in, filePath, StandardCopyOption.REPLACE_EXISTING);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean extractLibrary(String path, NativeLib library) throws IOException {
        Path sourcePath = Paths.get(BASE_PATH, library.fileName);
        Path targetPath = library.getTargetPath(Path.of(path, new String[0]));
        try (InputStream in = NativeLibManager.class.getClassLoader().getResourceAsStream(sourcePath.toString().replace("\\", "/"));){
            if (in == null) {
                LOGGER.error("{} \u63d0\u53d6\u5931\u8d25", (Object)sourcePath);
                boolean bl = false;
                return bl;
            }
            if (!NativeLibManager._writeFile(in, targetPath.toString())) throw new IOException(library.fileName + " \u63d0\u53d6\u5931\u8d25");
            library.extractedPath = targetPath;
            LOGGER.info("{} \u63d0\u53d6\u6210\u529f", (Object)library.fileName);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("{} \u63d0\u53d6\u5931\u8d25; \u4fe1\u606f: {}", (Object)library.fileName, (Object)e.toString());
            throw e;
        }
    }

    static {
        LIB_SUPER_RESOLUTION = null;
        LIB_NANOVG = null;
        LIB_SUPER_RESOLUTION_FSR = null;
        LIB_SUPER_RESOLUTION_XESS = null;
        LIB_SUPER_RESOLUTION_FSRGL = null;
        OperatingSystem operatingSystem = new OperatingSystem();
        if (operatingSystem.type == OperatingSystemType.WINDOWS && operatingSystem.arch == SystemArchitecture.X86_64) {
            LIB_SUPER_RESOLUTION = new NativeLib("SuperResolution", true);
            LIB_SUPER_RESOLUTION_FSR = new NativeLib("SuperResolutionFSR", false);
            LIB_SUPER_RESOLUTION_XESS = new NativeLib("SuperResolutionXeSS", false);
            LIB_NANOVG = new NativeLib("lwjgl_nanovg", false, true, Configuration.LIBRARY_PATH.get() == null ? null : Path.of((String)Configuration.LIBRARY_PATH.get(), new String[0]));
            libs.add(LIB_NANOVG);
            libs.add(LIB_SUPER_RESOLUTION);
        } else if (operatingSystem.type == OperatingSystemType.ANDROID && operatingSystem.arch == SystemArchitecture.AARCH64) {
            LIB_SUPER_RESOLUTION = new NativeLib("SuperResolution", true);
            libs.add(LIB_SUPER_RESOLUTION);
        } else if (operatingSystem.type == OperatingSystemType.LINUX && operatingSystem.arch == SystemArchitecture.X86_64) {
            LIB_SUPER_RESOLUTION = new NativeLib("SuperResolution", true);
            LIB_SUPER_RESOLUTION_FSR = new NativeLib("SuperResolutionFSR", false);
            LIB_NANOVG = new NativeLib("liblwjgl_nanovg", false, true, Configuration.LIBRARY_PATH.get() == null ? null : Path.of((String)Configuration.LIBRARY_PATH.get(), new String[0]));
            libs.add(LIB_NANOVG);
            libs.add(LIB_SUPER_RESOLUTION);
            libs.add(LIB_SUPER_RESOLUTION_FSR);
        } else if (operatingSystem.type == OperatingSystemType.MACOS && operatingSystem.arch == SystemArchitecture.AARCH64) {
            LIB_SUPER_RESOLUTION = new NativeLib("SuperResolution", true);
            libs.add(LIB_SUPER_RESOLUTION);
        }
    }

    public static class NativeLib {
        public final String baseName;
        public final String fileName;
        public final boolean loadAtStartup;
        public final Path preExtractPath;
        public Path extractedPath;
        public boolean available;
        public boolean nameIsPath;
        public Path targetPath;

        public NativeLib(String baseName, boolean loadAtStartup) {
            this(baseName, loadAtStartup, false);
        }

        public NativeLib(String baseName, boolean loadAtStartup, boolean nameIsPath) {
            this(baseName, loadAtStartup, false, null);
        }

        public NativeLib(String baseName, boolean loadAtStartup, boolean nameIsPath, Path targetPath) {
            this.baseName = baseName;
            this.loadAtStartup = loadAtStartup;
            this.fileName = NativeLib.buildFullFileName(baseName, nameIsPath);
            this.preExtractPath = Paths.get(NativeLibManager.BASE_PATH, this.fileName);
            this.nameIsPath = nameIsPath;
            this.targetPath = targetPath;
        }

        private static String buildFullFileName(String baseName, boolean nameIsPath) {
            OperatingSystem operatingSystem = new OperatingSystem();
            StringBuilder sb = new StringBuilder();
            if (!nameIsPath) {
                sb.append(NativeLibManager.BASE_PATH);
                sb.append(baseName);
                if (operatingSystem.type == OperatingSystemType.WINDOWS) {
                    sb.append("+win64");
                } else if (operatingSystem.type == OperatingSystemType.LINUX) {
                    sb.append("+linux64");
                } else if (operatingSystem.type == OperatingSystemType.MACOS) {
                    sb.append("+macarm64");
                } else if (operatingSystem.type == OperatingSystemType.ANDROID) {
                    sb.append("+android");
                }
                sb.append("+debug");
            } else {
                sb.append(baseName);
            }
            if (operatingSystem.type == OperatingSystemType.WINDOWS) {
                sb.append(".dll");
            } else if (operatingSystem.type == OperatingSystemType.LINUX || operatingSystem.type == OperatingSystemType.ANDROID) {
                sb.append(".so");
            } else if (operatingSystem.type == OperatingSystemType.MACOS) {
                sb.append(".dylib");
            }
            return sb.toString();
        }

        public Path getTargetPath(Path root) {
            this.extractedPath = this.targetPath != null ? this.targetPath.resolve(this.fileName) : root.resolve(this.fileName);
            return this.extractedPath;
        }
    }

    public static interface ExtendedKernel32
    extends Kernel32 {
        public DllDirectoryCookie AddDllDirectory(String var1);

        public static class DllDirectoryCookie
        extends PointerType {
            public DllDirectoryCookie() {
            }

            public DllDirectoryCookie(Pointer p) {
                super(p);
            }
        }
    }
}

