/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common;

import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import io.homo.superresolution.api.AbstractAlgorithm;
import io.homo.superresolution.api.event.AlgorithmResizeEvent;
import io.homo.superresolution.api.registry.AlgorithmDescription;
import io.homo.superresolution.api.utils.Requirement;
import io.homo.superresolution.common.config.Config;
import io.homo.superresolution.common.debug.imgui.ImguiMain;
import io.homo.superresolution.common.gui.ConfigScreenBuilder;
import io.homo.superresolution.common.minecraft.MinecraftRenderHandle;
import io.homo.superresolution.common.platform.EnvType;
import io.homo.superresolution.common.platform.OS;
import io.homo.superresolution.common.platform.OSType;
import io.homo.superresolution.common.platform.Platform;
import io.homo.superresolution.common.upscale.AlgorithmManager;
import io.homo.superresolution.common.upscale.none.None;
import io.homo.superresolution.core.GraphicsCapabilities;
import io.homo.superresolution.core.NativeLibManager;
import io.homo.superresolution.core.gl.GlState;
import io.homo.superresolution.core.glslang.GlslangShaderCompiler;
import io.homo.superresolution.core.impl.Destroyable;
import io.homo.superresolution.core.impl.Resizable;
import io.homo.superresolution.core.interop.GlVkInteropManager;
import io.homo.superresolution.core.utils.MessageBox;
import java.io.File;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SuperResolution
implements Resizable,
Destroyable {
    public static final String MOD_ID = "super_resolution";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SuperResolution");
    public static final Logger LOGGER_CPP = LoggerFactory.getLogger((String)"SuperResolution-CPP");
    private static final Requirement commonRequirement = Requirement.nothing().glMajorVersion(4).glMinorVersion(3).requiredGlExtension("GL_ARB_gl_spirv").requiredGlExtension("GL_ARB_direct_state_access");
    public static AbstractAlgorithm currentAlgorithm;
    public static None defaultAlgorithm;
    public static boolean isInit;
    public static boolean isPreInit;
    public static boolean gameIsLoad;
    public static float frameTimeDelta;
    public static AlgorithmDescription<?> algorithmDescription;
    public static GlVkInteropManager interopManager;
    public static int framebufferWidth;
    public static int framebufferHeight;
    public static int cachedWidth;
    public static int cachedHeight;
    private static class_310 minecraft;
    private static SuperResolution instance;
    public final class_304 OPENGUI_KEYMAPPING = new class_304("key.super_resolution.open_config", class_3675.class_307.field_1668, 295, "Super Resolution");

    public SuperResolution() {
        if (SuperResolution.minecraft == null) {
            SuperResolution.minecraft = class_310.method_1551();
        }
        KeyMappingRegistry.register((class_304)this.OPENGUI_KEYMAPPING);
        ClientTickEvent.CLIENT_POST.register(minecraft -> {
            while (this.OPENGUI_KEYMAPPING.method_1436()) {
                minecraft.method_1507(ConfigScreenBuilder.create().buildConfigScreen(minecraft.field_1755));
            }
        });
    }

    public static void preInit() {
        if (minecraft == null) {
            minecraft = class_310.method_1551();
        }
        File gameDir = Platform.currentPlatform.getGameFolder().toFile();
        if (Platform.currentPlatform.getEnv() == EnvType.SERVER) {
            throw new RuntimeException("SuperResolution\u4e0d\u652f\u6301\u5b89\u88c5\u5728\u670d\u52a1\u5668\u4e0a\uff01");
        }
        if (!NativeLibManager.check(gameDir.getAbsolutePath())) {
            NativeLibManager.extract(gameDir.getAbsolutePath());
        }
        NativeLibManager.load(gameDir.getAbsolutePath());
        GlslangShaderCompiler.init();
        if (new OS().type == OSType.WINDOWS) {
            interopManager = new GlVkInteropManager();
            SuperResolution.initVulkan();
        }
        isPreInit = true;
    }

    public static int getMinecraftWidth() {
        return Math.max(class_310.method_1551().method_22683().method_4480(), 1);
    }

    public static int getMinecraftHeight() {
        return Math.max(class_310.method_1551().method_22683().method_4507(), 1);
    }

    public static SuperResolution getInstance() {
        return instance;
    }

    public static void setFrameTimeDelta(float value) {
        frameTimeDelta = value;
    }

    public static void check() {
        if (minecraft == null) {
            minecraft = class_310.method_1551();
        }
        if (!commonRequirement.check().glVersionMet()) {
            MessageBox.createError(class_2561.method_43471((String)"superresolution.common_requirement.not_support.version").getString().formatted(commonRequirement.getGlMajorVersion(), commonRequirement.getGlMinorVersion(), GraphicsCapabilities.getGLVersion()[0], GraphicsCapabilities.getGLVersion()[1]), class_2561.method_43471((String)"superresolution.common_requirement.not_support.msg").getString());
            class_310.method_1551().method_1490();
        }
        if (!commonRequirement.check().glExtensionsPresent()) {
            StringBuilder extensionStringBuilder = new StringBuilder();
            for (String name : commonRequirement.getMissingGlExtensions()) {
                extensionStringBuilder.append(name).append("\n");
            }
            MessageBox.createError(class_2561.method_43471((String)"superresolution.common_requirement.not_support.extension").getString().formatted(extensionStringBuilder.toString()), class_2561.method_43471((String)"superresolution.common_requirement.not_support.msg").getString());
            class_310.method_1551().method_1490();
        }
    }

    public static void initRendering() {
        try (GlState ignored = new GlState();){
            if (minecraft == null) {
                minecraft = class_310.method_1551();
            }
            if (!isPreInit) {
                return;
            }
            MinecraftRenderHandle.init();
            AlgorithmManager.init();
            algorithmDescription = Config.getUpscaleAlgo();
        }
    }

    public static boolean createAlgo() {
        try (GlState ignored = new GlState();){
            if (minecraft == null) {
                minecraft = class_310.method_1551();
            }
            if (!isPreInit) {
                boolean bl = false;
                return bl;
            }
            defaultAlgorithm.init();
            algorithmDescription = Config.getUpscaleAlgo();
            try {
                currentAlgorithm = algorithmDescription.createNewInstance();
                LOGGER.info("\u521d\u59cb\u5316\u7b97\u6cd5 {}", (Object)algorithmDescription.getDisplayName());
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                LOGGER.info("\u521d\u59cb\u5316\u7b97\u6cd5 {} \u65f6\u5931\u8d25 \u9519\u8bef:", (Object)algorithmDescription.getDisplayName());
                e.printStackTrace();
                ignored.close();
            }
        }
        return false;
    }

    public static void initVulkan() {
        interopManager.init();
    }

    public static void callAlgo(Consumer<AbstractAlgorithm> fn) {
        if (currentAlgorithm != null) {
            fn.accept(currentAlgorithm);
        }
    }

    public static AbstractAlgorithm getCurrentAlgorithm() {
        if (Config.isEnableUpscale() && currentAlgorithm != null) {
            return currentAlgorithm;
        }
        return defaultAlgorithm;
    }

    public void init() {
        if (minecraft == null) {
            minecraft = class_310.method_1551();
        }
        if (isInit) {
            return;
        }
        instance = this;
        if (Platform.currentPlatform.isDevelopmentEnvironment() && Config.isEnableImgui()) {
            new ImguiMain();
        }
        isInit = true;
        this.resize(SuperResolution.getMinecraftWidth(), SuperResolution.getMinecraftHeight());
    }

    @Override
    public void resize(int width, int height) {
        cachedWidth = SuperResolution.getMinecraftWidth();
        cachedHeight = SuperResolution.getMinecraftHeight();
        if (currentAlgorithm != null) {
            AlgorithmResizeEvent.EVENT.invoker().onAlgorithmRegister(currentAlgorithm, MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight(), MinecraftRenderHandle.getRenderWidth(), MinecraftRenderHandle.getRenderHeight());
            currentAlgorithm.resize(SuperResolution.getMinecraftWidth(), SuperResolution.getMinecraftHeight());
        }
        AlgorithmManager.resize(SuperResolution.getMinecraftWidth(), SuperResolution.getMinecraftHeight());
    }

    @Override
    public void destroy() {
        if (interopManager != null) {
            interopManager.destroy();
        }
        if (currentAlgorithm != null) {
            currentAlgorithm.destroy();
        }
        AlgorithmManager.destroy();
    }

    static {
        defaultAlgorithm = new None();
        gameIsLoad = false;
        frameTimeDelta = 16.6f;
        framebufferWidth = 0;
        framebufferHeight = 0;
        minecraft = class_310.method_1551();
    }
}

