/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.fsr2.pipelines;

import io.homo.superresolution.core.GpuVendor;
import io.homo.superresolution.core.GraphicsCapabilities;
import io.homo.superresolution.core.gl.pipeline.GlPipelineJobBuilders;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceAccess;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceDescription;
import io.homo.superresolution.core.gl.shader.GlComputeShaderProgram;
import io.homo.superresolution.core.impl.Vec3;
import io.homo.superresolution.core.impl.shader.ShaderSource;
import io.homo.superresolution.fsr2.Fsr2Context;
import io.homo.superresolution.fsr2.Fsr2Dimensions;
import io.homo.superresolution.fsr2.Fsr2PipelineDispatchResource;
import io.homo.superresolution.fsr2.Fsr2PipelineResourceType;
import io.homo.superresolution.fsr2.Fsr2ShaderResource;
import io.homo.superresolution.fsr2.pipelines.Fsr2BasePipeline;
import java.util.HashMap;

public class Fsr2AccumulatePipeline
extends Fsr2BasePipeline {
    private GlComputeShaderProgram program;

    public Fsr2AccumulatePipeline(Fsr2Context resources) {
        super(resources);
    }

    @Override
    public void resize(Fsr2Dimensions size) {
    }

    @Override
    public void destroy() {
        this.program.destroy();
    }

    @Override
    public void init() {
        HashMap<String, String> shaderDefines = new HashMap<String, String>();
        shaderDefines.put("FFX_HALF", GraphicsCapabilities.detectGpuVendor() == GpuVendor.NVIDIA ? "0" : "1");
        this.program = ((GlComputeShaderProgram)GlComputeShaderProgram.create().addDefineText(this.getShaderDefines(shaderDefines)).setShaderName("fsr2_accumulate").addShaderSource(new ShaderSource(ShaderSource.Type.COMPUTE, "/shader/fsr2/ffx_fsr2_accumulate_pass.ogl.glsl", true)).build()).compileShader();
    }

    @Override
    public void execute(Fsr2PipelineDispatchResource dispatchResource) {
        GlPipelineJobBuilders.ComputeJobBuilder jobBuilder = GlPipelineJobBuilders.compute(this.program).workGroupSupplier(() -> new Vec3((float)(this.context.dimensions.screenWidth() + 7) / 8.0f, (float)(this.context.dimensions.screenHeight() + 7) / 8.0f, 1.0f));
        jobBuilder.resource(GlPipelineResourceDescription.createUBOResource("cbFSR2", this.context.fsr2ConstantsUBO, 18));
        jobBuilder.resource(new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.INPUT_EXPOSURE).binding(13).access(GlPipelineResourceAccess.READ).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.DILATED_REACTIVE_MASKS).binding(14).access(GlPipelineResourceAccess.READ).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceTypeSupplier(!this.context.config.flags.isEnableDisplayResolutionMotionVectors() ? () -> Fsr2PipelineResourceType.INPUT_MOTION_VECTORS : () -> this.context.isOddFrame() ? Fsr2PipelineResourceType.INTERNAL_DILATED_MOTION_VECTORS_2 : Fsr2PipelineResourceType.INTERNAL_DILATED_MOTION_VECTORS_1).resourceName(!this.context.config.flags.isEnableDisplayResolutionMotionVectors() ? Fsr2PipelineResourceType.INPUT_MOTION_VECTORS.srvShaderName() : Fsr2PipelineResourceType.DILATED_MOTION_VECTORS.srvShaderName()).binding(15).access(GlPipelineResourceAccess.READ).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceTypeSupplier(() -> this.context.isOddFrame() ? Fsr2PipelineResourceType.INTERNAL_UPSCALED_COLOR_2 : Fsr2PipelineResourceType.INTERNAL_UPSCALED_COLOR_1).resourceName(Fsr2PipelineResourceType.INTERNAL_UPSCALED_COLOR.srvShaderName()).binding(16).access(GlPipelineResourceAccess.READ).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceTypeSupplier(() -> this.context.isOddFrame() ? Fsr2PipelineResourceType.LOCK_STATUS_2 : Fsr2PipelineResourceType.LOCK_STATUS_1).resourceName(Fsr2PipelineResourceType.LOCK_STATUS.srvShaderName()).binding(17).access(GlPipelineResourceAccess.READ).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.PREPARED_INPUT_COLOR).binding(6).access(GlPipelineResourceAccess.READ).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.LANCZOS_LUT).binding(8).access(GlPipelineResourceAccess.READ).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.UPSAMPLE_MAXIMUM_BIAS_LUT).binding(9).access(GlPipelineResourceAccess.READ).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.SCENE_LUMINANCE).binding(10).access(GlPipelineResourceAccess.READ).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.AUTO_EXPOSURE).binding(11).access(GlPipelineResourceAccess.READ).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceTypeSupplier(() -> this.context.isOddFrame() ? Fsr2PipelineResourceType.LUMA_HISTORY_2 : Fsr2PipelineResourceType.LUMA_HISTORY_1).resourceName(Fsr2PipelineResourceType.LUMA_HISTORY.srvShaderName()).binding(12).access(GlPipelineResourceAccess.READ).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceTypeSupplier(() -> this.context.isOddFrame() ? Fsr2PipelineResourceType.INTERNAL_UPSCALED_COLOR_1 : Fsr2PipelineResourceType.INTERNAL_UPSCALED_COLOR_2).resourceName(Fsr2PipelineResourceType.INTERNAL_UPSCALED_COLOR.uavShaderName()).binding(0).access(GlPipelineResourceAccess.BOTH).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceTypeSupplier(() -> this.context.isOddFrame() ? Fsr2PipelineResourceType.LOCK_STATUS_1 : Fsr2PipelineResourceType.LOCK_STATUS_2).resourceName(Fsr2PipelineResourceType.LOCK_STATUS.uavShaderName()).binding(1).access(GlPipelineResourceAccess.BOTH).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.UPSCALED_OUTPUT).binding(2).access(GlPipelineResourceAccess.BOTH).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.NEW_LOCKS).binding(3).access(GlPipelineResourceAccess.BOTH).getResourceDescription(this.context));
        jobBuilder.resource(new Fsr2ShaderResource().resourceTypeSupplier(() -> this.context.isOddFrame() ? Fsr2PipelineResourceType.LUMA_HISTORY_1 : Fsr2PipelineResourceType.LUMA_HISTORY_2).resourceName(Fsr2PipelineResourceType.LUMA_HISTORY.uavShaderName()).binding(4).access(GlPipelineResourceAccess.BOTH).getResourceDescription(this.context));
        this.pipeline.addJob("fsr2_accumulate", jobBuilder.build());
        this.pipeline.scheduleJobs();
        this.pipeline.executeJobs();
    }
}

