/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import io.homo.superresolution.api.AbstractAlgorithm;
import io.homo.superresolution.api.event.AlgorithmResizeEvent;
import io.homo.superresolution.api.platform.EnvironmentType;
import io.homo.superresolution.api.platform.Platform;
import io.homo.superresolution.api.registry.AlgorithmDescription;
import io.homo.superresolution.api.utils.Requirement;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.dataset.DataSetGenerator;
import io.homo.superresolution.common.debug.imgui.ImguiMain;
import io.homo.superresolution.common.gui.ConfigScreenBuilder;
import io.homo.superresolution.common.minecraft.MinecraftWindow;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.common.upscale.AlgorithmManager;
import io.homo.superresolution.common.upscale.none.None;
import io.homo.superresolution.core.NativeLibManager;
import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.GraphicsCapabilities;
import io.homo.superresolution.core.graphics.glslang.GlslangShaderCompiler;
import io.homo.superresolution.core.graphics.opengl.GlState;
import io.homo.superresolution.core.gui.MaterialUI;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVG;
import io.homo.superresolution.core.impl.Destroyable;
import io.homo.superresolution.core.impl.Resizable;
import io.homo.superresolution.core.utils.MessageBox;
import java.io.File;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SuperResolution
implements Resizable,
Destroyable {
    public static final String MOD_ID = "super_resolution";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SuperResolution");
    public static final Logger LOGGER_CPP = LoggerFactory.getLogger((String)"SuperResolution-CPP");
    private static final Requirement commonRequirement = Requirement.nothing().glMajorVersion(4).glMinorVersion(1);
    public static AbstractAlgorithm currentAlgorithm;
    public static None defaultAlgorithm;
    public static boolean isInit;
    public static boolean isPreInit;
    public static boolean gameIsLoad;
    public static AlgorithmDescription<?> algorithmDescription;
    public static int framebufferWidth;
    public static int framebufferHeight;
    public static int cachedWidth;
    public static int cachedHeight;
    public static Thread renderThread;
    private static class_310 minecraft;
    private static SuperResolution instance;
    public static final class_304 OPENGUI_KEYMAPPING;
    private static boolean registeredKeyMapping;

    public static void registerKeyMapping() {
        if (!registeredKeyMapping) {
            if (SuperResolutionConfig.isEnableDatasetGenerator()) {
                DataSetGenerator.init();
            }
            KeyMappingRegistry.register((class_304)OPENGUI_KEYMAPPING);
        }
        registeredKeyMapping = true;
    }

    public static void registerEvents() {
        ClientLifecycleEvent.CLIENT_SETUP.register(minecraft -> SuperResolution.registerKeyMapping());
        ClientLifecycleEvent.CLIENT_STARTED.register(minecraft -> {
            SuperResolution.registerKeyMapping();
            instance = new SuperResolution();
            SuperResolution.preInit();
            SuperResolution.initRendering();
            SuperResolution.createAlgorithm();
            SuperResolution.getInstance().init();
            NanoVG.init();
            MaterialUI.init();
        });
        ClientLifecycleEvent.CLIENT_STOPPING.register(minecraft -> SuperResolution.getInstance().destroy());
        ClientTickEvent.CLIENT_POST.register(minecraft -> {
            while (OPENGUI_KEYMAPPING.method_1436()) {
                minecraft.method_1507(ConfigScreenBuilder.create().buildConfigScreen(minecraft.field_1755));
            }
        });
    }

    public SuperResolution() {
        instance = this;
        if (minecraft == null) {
            minecraft = class_310.method_1551();
        }
    }

    public static void preInit() {
        if (minecraft == null) {
            minecraft = class_310.method_1551();
        }
        File gameDir = Platform.currentPlatform.getGameFolder().toFile();
        if (Platform.currentPlatform.getEnv() == EnvironmentType.SERVER) {
            throw new RuntimeException("SuperResolution\u4e0d\u652f\u6301\u5b89\u88c5\u5728\u670d\u52a1\u5668\u4e0a\uff01");
        }
        NativeLibManager.extract(gameDir.getAbsolutePath());
        NativeLibManager.load(gameDir.getAbsolutePath());
        GlslangShaderCompiler.init();
        isPreInit = true;
    }

    public static SuperResolution getInstance() {
        return instance;
    }

    public static void check() {
        if (minecraft == null) {
            minecraft = class_310.method_1551();
        }
        if (!commonRequirement.check().glVersionMet()) {
            MessageBox.createError(class_2561.method_43471((String)"superresolution.common_requirement.not_support.version").getString().formatted(commonRequirement.getGlMajorVersion(), commonRequirement.getGlMinorVersion(), GraphicsCapabilities.getGLVersion()[0], GraphicsCapabilities.getGLVersion()[1]), class_2561.method_43471((String)"superresolution.common_requirement.not_support.msg").getString());
            System.exit(1);
        }
        if (!commonRequirement.check().glExtensionsPresent()) {
            StringBuilder extensionStringBuilder = new StringBuilder();
            for (String name : commonRequirement.getMissingGlExtensions()) {
                extensionStringBuilder.append(name).append("\n");
            }
            MessageBox.createError(class_2561.method_43471((String)"superresolution.common_requirement.not_support.extension").getString().formatted(extensionStringBuilder.toString()), class_2561.method_43471((String)"superresolution.common_requirement.not_support.msg").getString());
            System.exit(1);
        }
    }

    public static void initRendering() {
        renderThread = Thread.currentThread();
        try (GlState ignored = new GlState();){
            RenderSystems.init();
            if (minecraft == null) {
                minecraft = class_310.method_1551();
            }
            if (!isPreInit) {
                return;
            }
            LOGGER.info("\u663e\u5361\u4f9b\u5e94\u5546 {}", (Object)GraphicsCapabilities.detectGpuVendor().name());
            LOGGER.info("OpenGL\u7248\u672c {}", (Object)GraphicsCapabilities.getGLVersionString());
            RenderHandlerManager.initialize();
            AlgorithmManager.init();
            algorithmDescription = SuperResolutionConfig.getUpscaleAlgorithm();
        }
    }

    public static boolean createAlgorithm() {
        try (GlState ignored = new GlState();){
            if (minecraft == null) {
                minecraft = class_310.method_1551();
            }
            if (!isPreInit) {
                boolean bl = false;
                return bl;
            }
            defaultAlgorithm.init();
            algorithmDescription = SuperResolutionConfig.getUpscaleAlgorithm();
            try {
                currentAlgorithm = algorithmDescription.createNewInstance();
                LOGGER.info("\u521d\u59cb\u5316\u7b97\u6cd5 {}", (Object)algorithmDescription.getDisplayName());
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                LOGGER.info("\u521d\u59cb\u5316\u7b97\u6cd5 {} \u65f6\u5931\u8d25 \u9519\u8bef:", (Object)algorithmDescription.getDisplayName());
                e.printStackTrace();
                ignored.close();
            }
        }
        return false;
    }

    public static boolean recreateAlgorithm() {
        try (GlState ignored = new GlState();){
            if (minecraft == null) {
                minecraft = class_310.method_1551();
            }
            if (!isPreInit) {
                boolean bl = false;
                return bl;
            }
            if (currentAlgorithm != null) {
                currentAlgorithm.destroy();
            }
            try {
                currentAlgorithm = algorithmDescription.createNewInstance();
                currentAlgorithm.init();
                currentAlgorithm.resize(MinecraftWindow.getWindowWidth(), MinecraftWindow.getWindowHeight());
                AlgorithmResizeEvent.EVENT.invoker().onAlgorithmResize(currentAlgorithm, RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight(), RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight());
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                LOGGER.error("\u521d\u59cb\u5316\u7b97\u6cd5 {} \u65f6\u5931\u8d25\uff1a", (Object)algorithmDescription.getDisplayName(), (Object)e);
                ignored.close();
            }
        }
        return false;
    }

    public static AbstractAlgorithm getCurrentAlgorithm() {
        if (SuperResolutionConfig.isEnableUpscale() && currentAlgorithm != null) {
            return currentAlgorithm;
        }
        return defaultAlgorithm;
    }

    public void init() {
        if (minecraft == null) {
            minecraft = class_310.method_1551();
        }
        if (isInit) {
            return;
        }
        if (Platform.currentPlatform.isDevelopmentEnvironment() && SuperResolutionConfig.isEnableImgui()) {
            new ImguiMain();
        }
        isInit = true;
        this.resize(MinecraftWindow.getWindowWidth(), MinecraftWindow.getWindowHeight());
    }

    @Override
    public void resize(int width, int height) {
        cachedWidth = MinecraftWindow.getWindowWidth();
        cachedHeight = MinecraftWindow.getWindowHeight();
        if (currentAlgorithm != null) {
            AlgorithmResizeEvent.EVENT.invoker().onAlgorithmResize(currentAlgorithm, RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight(), RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight());
            currentAlgorithm.resize(MinecraftWindow.getWindowWidth(), MinecraftWindow.getWindowHeight());
        }
        AlgorithmManager.resize(MinecraftWindow.getWindowWidth(), MinecraftWindow.getWindowHeight());
    }

    @Override
    public void destroy() {
        if (currentAlgorithm != null) {
            currentAlgorithm.destroy();
        }
        AlgorithmManager.destroy();
        RenderSystems.destroy();
    }

    static {
        defaultAlgorithm = new None();
        gameIsLoad = false;
        framebufferWidth = 0;
        framebufferHeight = 0;
        minecraft = class_310.method_1551();
        OPENGUI_KEYMAPPING = new class_304("key.super_resolution.open_config", class_3675.class_307.field_1668, 295, "Super Resolution");
        registeredKeyMapping = false;
    }
}

