/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.debug.imgui;

import imgui.ImGui;
import io.homo.superresolution.api.AbstractAlgorithm;
import io.homo.superresolution.api.SuperResolutionAPI;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.common.upscale.AlgorithmDescriptions;
import io.homo.superresolution.common.upscale.AlgorithmManager;
import io.homo.superresolution.common.upscale.fsr2.FSR2;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.opengl.buffer.GlBuffer;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2Context;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2PipelineResourceType;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2PipelineResources;
import java.util.Map;
import net.minecraft.class_310;
import org.joml.Matrix4f;

public class ImGuiLayer {
    private static final int PREVIEW_WIDTH = 500;
    public float[] blurPhi = new float[1];
    public float[] blurM = new float[1];

    public void imgui() {
        float previewHeight = 500.0f / (float)RenderHandlerManager.getScreenWidth() * (float)RenderHandlerManager.getScreenHeight();
        ImGui.begin((String)"DEBUG");
        this.drawCaptureButtons();
        if (!SuperResolution.gameIsLoad || SuperResolution.currentAlgorithm == null || class_310.method_1551().field_1687 == null) {
            ImGui.end();
            return;
        }
        this.drawProjectionMatrix();
        this.drawDebugTextures(previewHeight);
        this.drawFsr2Resources(previewHeight);
        ImGui.end();
    }

    private void drawCaptureButtons() {
        if (ImGui.button((String)"Capture")) {
            SuperResolutionAPI.debugRenderdocCapture();
        }
        if (ImGui.button((String)"CaptureUpscale")) {
            SuperResolutionAPI.debugRenderdocCaptureUpscale();
        }
        if (ImGui.button((String)"CaptureVulkan")) {
            SuperResolutionAPI.debugRenderdocCaptureVulkan();
        }
        if (ImGui.button((String)"TriggerCapture")) {
            SuperResolutionAPI.debugRenderdocTriggerCapture();
        }
    }

    private void drawProjectionMatrix() {
        Matrix4f m = AlgorithmManager.param.currentProjectionMatrix;
        if (m == null) {
            return;
        }
        float[] values = new float[16];
        m.get(values);
        for (int row = 0; row < 4; ++row) {
            ImGui.text((String)String.format("%f %f %f %f", Float.valueOf(values[row * 4]), Float.valueOf(values[row * 4 + 1]), Float.valueOf(values[row * 4 + 2]), Float.valueOf(values[row * 4 + 3])));
        }
    }

    private void drawDebugTextures(float height) {
        if (RenderHandlerManager.getColorTexture() != null) {
            this.drawImage("Input Color Texture", (int)RenderHandlerManager.getColorTexture().handle(), RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight(), height);
        }
        if (RenderHandlerManager.getDepthTexture() != null) {
            this.drawImage("Input Depth Texture", (int)RenderHandlerManager.getDepthTexture().handle(), RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight(), height);
        }
        this.drawImage("Generated Motion Vectors", AlgorithmManager.getMotionVectorsFrameBuffer().getTextureId(FrameBufferAttachmentType.Color), RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight(), height);
        this.drawImage("Upscale Output", SuperResolution.currentAlgorithm.getOutputTextureId(), RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight(), height);
    }

    private void drawFsr2Resources(float height) {
        AbstractAlgorithm abstractAlgorithm;
        if (SuperResolutionConfig.getUpscaleAlgorithm() != AlgorithmDescriptions.FSR2 || !((abstractAlgorithm = SuperResolution.getCurrentAlgorithm()) instanceof FSR2)) {
            return;
        }
        FSR2 fsr2 = (FSR2)abstractAlgorithm;
        Fsr2Context context = fsr2.fsr2Context;
        for (Map.Entry<Fsr2PipelineResourceType, Fsr2PipelineResources.Fsr2ResourceEntry> entry : context.resources.resources().entrySet()) {
            if (entry.getValue().getResource() == null || entry.getValue().getResource() instanceof GlBuffer) continue;
            ITexture texture = (ITexture)entry.getValue().getResource();
            this.drawImage(entry.getValue().getDescription().label, (int)texture.handle(), texture.getWidth(), texture.getHeight(), height);
        }
    }

    private void drawImage(String label, int textureId, int texWidth, int texHeight, float previewHeight) {
        ImGui.text((String)(label + " " + texWidth + " " + texHeight));
        ImGui.image((long)textureId, (float)500.0f, (float)previewHeight, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f);
    }

    private void drawImageIfExists(String label, Object handle, int texWidth, int texHeight, float previewHeight) {
        if (handle == null) {
            return;
        }
        if (handle instanceof Integer) {
            Integer id = (Integer)handle;
            this.drawImage(label, id, texWidth, texHeight, previewHeight);
        } else if (handle instanceof Long) {
            Long id = (Long)handle;
            this.drawImage(label, (int)id.longValue(), texWidth, texHeight, previewHeight);
        }
    }
}

