/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.options;

import com.google.common.collect.ImmutableList;
import io.homo.superresolution.common.gui.impl.Text;
import io.homo.superresolution.common.gui.options.AbstractOptionBuilder;
import io.homo.superresolution.common.gui.options.EnumListEntry;
import io.homo.superresolution.common.gui.options.SelectionListOptionEntry;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumSelectorBuilder<T extends Enum<T>>
extends AbstractOptionBuilder<T, SelectionListOptionEntry<T>, EnumSelectorBuilder<T>> {
    private final Class<T> clazz;
    private Function<Enum<T>, String> enumNameProvider;

    public EnumSelectorBuilder(Text fieldName, Class<T> clazz, T value) {
        super(fieldName, value);
        Objects.requireNonNull(clazz, "Enum class must not be null");
        Objects.requireNonNull(value, "Enum value must not be null");
        this.clazz = clazz;
        this.enumNameProvider = t -> t.name();
    }

    public EnumSelectorBuilder<T> setEnumNameProvider(@NotNull Function<Enum<T>, String> enumNameProvider) {
        Objects.requireNonNull(enumNameProvider, "Enum name provider must not be null");
        this.enumNameProvider = enumNameProvider;
        return this;
    }

    @Override
    public EnumSelectorBuilder<T> setDefaultValue(@Nullable Supplier<T> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public EnumSelectorBuilder<T> setDefaultValue(@NotNull T defaultValue) {
        Objects.requireNonNull(defaultValue, "Default value must not be null");
        this.defaultValue = () -> defaultValue;
        return this;
    }

    @Override
    public EnumListEntry<T> build() {
        EnumListEntry<Enum> entry = new EnumListEntry<Enum>(this.name, (Enum)this.value, ImmutableList.copyOf((Object[])((Enum[])this.clazz.getEnumConstants())));
        entry.setNameProvider(this.enumNameProvider);
        entry.setTooltipSupplier(v -> (Optional)this.tooltipSupplier.apply(v));
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(v -> (Optional)this.errorSupplier.apply(v));
        }
        return this.finishBuild(entry);
    }
}

