/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.graphics.impl.framebuffer.IBindableFrameBuffer;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFilterMode;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureMipmapSettings;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.impl.texture.TextureWrapMode;
import io.homo.superresolution.core.graphics.opengl.GlDebug;
import net.minecraft.class_276;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL43;

public class LegacyStorageFrameBuffer
extends class_276
implements IFrameBuffer,
IBindableFrameBuffer {
    private int colorAttachment1 = -1;
    private boolean stencilEnabled = false;
    private String label;

    public LegacyStorageFrameBuffer(boolean useDepth) {
        super(useDepth);
    }

    public void method_1231(int width, int height, boolean clearError) {
        RenderSystem.assertOnRenderThreadOrInit();
        int maxSupportedTextureSize = RenderSystem.maxSupportedTextureSize();
        if (width > 0 && width <= maxSupportedTextureSize && height > 0 && height <= maxSupportedTextureSize) {
            this.field_1480 = width;
            this.field_1477 = height;
            this.field_1482 = width;
            this.field_1481 = height;
            this.field_1483 = 9728;
            this.field_1476 = GL43.glGenFramebuffers();
            this.field_1475 = TextureUtil.generateTextureId();
            this.field_1474 = TextureUtil.generateTextureId();
            this.colorAttachment1 = TextureUtil.generateTextureId();
            if (this.label == null) {
                this.label = "SRLegacyStorageFrameBuffer";
            }
            GL43.glBindFramebuffer((int)36160, (int)this.field_1476);
            GL43.glBindTexture((int)3553, (int)this.field_1474);
            GL43.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL43.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL43.glTexParameteri((int)3553, (int)34892, (int)0);
            GL43.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL43.glTexParameteri((int)3553, (int)10243, (int)33071);
            if (this.stencilEnabled) {
                GL43.glTexStorage2D((int)3553, (int)1, (int)35056, (int)this.field_1482, (int)this.field_1481);
                GL43.glFramebufferTexture2D((int)36160, (int)36128, (int)3553, (int)this.field_1474, (int)0);
            } else {
                GL43.glTexStorage2D((int)3553, (int)1, (int)33190, (int)this.field_1482, (int)this.field_1481);
            }
        } else {
            throw new IllegalArgumentException("Window " + width + "x" + height + " size out of bounds (max. size: " + maxSupportedTextureSize + ")");
        }
        GL43.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.field_1474, (int)0);
        GL43.glBindTexture((int)3553, (int)this.field_1475);
        GL43.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL43.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL43.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL43.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL43.glTexStorage2D((int)3553, (int)1, (int)32856, (int)this.field_1482, (int)this.field_1481);
        GL43.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.field_1475, (int)0);
        GL43.glBindTexture((int)3553, (int)this.colorAttachment1);
        GL43.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL43.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL43.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL43.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL43.glTexStorage2D((int)3553, (int)1, (int)TextureFormat.RG16F.gl(), (int)this.field_1482, (int)this.field_1481);
        this.method_1239();
        this.method_1230(clearError);
        this.method_1242();
        GlDebug.objectLabel(36160, this.field_1476, this.label);
        GlDebug.objectLabel(5890, this.field_1475, this.label + "-ColorTexture");
        GlDebug.objectLabel(5890, this.field_1474, this.label + "-DepthTexture");
    }

    public void enableStencil() {
        if (!this.stencilEnabled) {
            this.stencilEnabled = true;
            this.method_1234(this.field_1480, this.field_1477, class_310.field_1703);
        }
    }

    public boolean isStencilEnabled() {
        return this.stencilEnabled;
    }

    @Override
    public int getWidth() {
        return this.field_1482;
    }

    @Override
    public int getHeight() {
        return this.field_1481;
    }

    @Override
    public void destroy() {
        this.method_1238();
    }

    @Override
    public void clearFrameBuffer() {
        this.method_1230(class_310.field_1703);
    }

    @Override
    public void resizeFrameBuffer(int width, int height) {
        this.method_1234(width, height, class_310.field_1703);
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint, boolean setViewport) {
        if (bindPoint == FrameBufferBindPoint.Read) {
            this.method_35610();
        } else {
            this.method_1235(setViewport);
        }
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint) {
        this.bind(bindPoint, true);
    }

    @Override
    public void unbind(FrameBufferBindPoint bindPoint) {
        if (bindPoint == FrameBufferBindPoint.Read) {
            this.method_1242();
        } else if (bindPoint == FrameBufferBindPoint.Write) {
            this.method_1240();
        } else {
            this.method_1242();
            this.method_1240();
        }
    }

    @Override
    public int getTextureId(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new MatchException(null, null);
            case FrameBufferAttachmentType.Color -> {
                if (attachmentType.getIndex() == 0) {
                    yield this.field_1475;
                }
                yield this.colorAttachment1;
            }
            case FrameBufferAttachmentType.AnyDepth, FrameBufferAttachmentType.Depth -> this.field_1474;
            case FrameBufferAttachmentType.DepthStencil -> this.stencilEnabled ? this.field_1474 : -1;
        };
    }

    @Override
    public ITexture getTexture(FrameBufferAttachmentType attachmentType) {
        return attachmentType == FrameBufferAttachmentType.Color ? new LegacyFrameBufferTextureAdapter(false, false) : new LegacyFrameBufferTextureAdapter(true, this.stencilEnabled);
    }

    @Override
    public long handle() {
        return this.field_1476;
    }

    @Override
    public TextureFormat getColorTextureFormat() {
        return TextureFormat.RGBA8;
    }

    @Override
    public TextureFormat getDepthTextureFormat() {
        return this.stencilEnabled ? TextureFormat.DEPTH24_STENCIL8 : TextureFormat.DEPTH24;
    }

    @Override
    public void setClearColorRGBA(float red, float green, float blue, float alpha) {
        super.method_1236(red, green, blue, alpha);
    }

    @Override
    public class_276 asMcRenderTarget() {
        return this;
    }

    @Override
    public void label(String label) {
        this.label = label;
    }

    class LegacyFrameBufferTextureAdapter
    implements ITexture {
        private final boolean isDepth;
        private final boolean isStencil;

        private LegacyFrameBufferTextureAdapter(boolean isDepth, boolean isStencil) {
            this.isDepth = isDepth;
            this.isStencil = isStencil;
        }

        @Override
        public TextureFormat getTextureFormat() {
            if (this.isDepth && this.isStencil) {
                return TextureFormat.DEPTH24_STENCIL8;
            }
            if (this.isDepth) {
                return TextureFormat.DEPTH24;
            }
            return TextureFormat.RGBA8;
        }

        @Override
        public TextureUsages getTextureUsages() {
            return TextureUsages.create().sampler().storage().copy();
        }

        @Override
        public TextureDescription getTextureDescription() {
            return TextureDescription.create().filterMode(this.getTextureFilterMode()).format(this.getTextureFormat()).size(this.getWidth(), this.getHeight()).type(this.getTextureType()).wrapMode(this.getTextureWrapMode()).mipmapSettings(this.getMipmapSettings()).usages(this.getTextureUsages()).build();
        }

        @Override
        public TextureType getTextureType() {
            return TextureType.Texture2D;
        }

        @Override
        public TextureFilterMode getTextureFilterMode() {
            return TextureFilterMode.Nearest;
        }

        @Override
        public TextureWrapMode getTextureWrapMode() {
            return TextureWrapMode.ClampToEdge;
        }

        @Override
        public TextureMipmapSettings getMipmapSettings() {
            return TextureMipmapSettings.disabled();
        }

        @Override
        public int getWidth() {
            return LegacyStorageFrameBuffer.this.field_1482;
        }

        @Override
        public int getHeight() {
            return LegacyStorageFrameBuffer.this.field_1481;
        }

        @Override
        public long handle() {
            return this.isDepth ? (long)LegacyStorageFrameBuffer.this.field_1474 : (long)LegacyStorageFrameBuffer.this.field_1475;
        }

        @Override
        public void destroy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void resize(int width, int height) {
            throw new UnsupportedOperationException();
        }
    }
}

