/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core;

import io.homo.superresolution.api.platform.OperatingSystemType;
import io.homo.superresolution.api.platform.Platform;
import io.homo.superresolution.core.graphics.opengl.GlRenderSystem;
import io.homo.superresolution.core.graphics.vulkan.VkRenderSystem;
import io.homo.superresolution.core.graphics.vulkan.utils.VulkanException;
import org.lwjgl.vulkan.VK;

public class RenderSystems {
    private static VkRenderSystem vulkan;
    private static GlRenderSystem opengl;

    public static void init() {
        opengl = new GlRenderSystem();
        opengl.initRenderSystem();
        RenderSystems.initVulkan();
    }

    public static void destroy() {
        opengl.destroyRenderSystem();
        if (vulkan != null) {
            vulkan.destroyRenderSystem();
        }
    }

    public static boolean isSupportVulkan() {
        return vulkan != null;
    }

    public static boolean isSupportOpenGL() {
        return true;
    }

    private static void initVulkan() {
        block7: {
            try {
                VK.create();
            }
            catch (Error | Exception e) {
                if (e.getMessage().contains("Vulkan has already been created")) break block7;
                VkRenderSystem.LOGGER.error("Vulkan\u521d\u59cb\u5316\u5931\u8d25\uff0c\u4f3c\u4e4e\u7f3a\u5c11Vulkan\u8fd0\u884c\u5e93\uff0c\u9519\u8bef {}", (Object)e.getMessage());
                e.printStackTrace();
                return;
            }
        }
        vulkan = new VkRenderSystem();
        vulkan.addInstanceExtension("VK_KHR_external_semaphore_capabilities").addInstanceExtension("VK_KHR_external_memory_capabilities").addInstanceExtension("VK_EXT_debug_utils").addDeviceExtension("VK_KHR_external_semaphore").addDeviceExtension("VK_EXT_mutable_descriptor_type").addDeviceExtension("VK_KHR_shader_float16_int8").addDeviceExtension("VK_KHR_shader_integer_dot_product").addDeviceExtension("VK_KHR_external_memory").addDeviceExtension("VK_KHR_dedicated_allocation").addDeviceExtension("VK_KHR_get_memory_requirements2");
        if (Platform.currentPlatform.getOS().type == OperatingSystemType.WINDOWS) {
            vulkan.addDeviceExtension("VK_KHR_external_memory_win32").addDeviceExtension("VK_KHR_external_semaphore_win32");
        }
        if (Platform.currentPlatform.getOS().type == OperatingSystemType.LINUX) {
            vulkan.addDeviceExtension("VK_KHR_external_memory_fd").addDeviceExtension("VK_KHR_external_semaphore_fd");
        }
        try {
            vulkan.initRenderSystem();
            return;
        }
        catch (VulkanException vkException) {
            VkRenderSystem.LOGGER.error("Vulkan\u521d\u59cb\u5316\u5931\u8d25\uff0c\u5df2\u7981\u7528Vulkan\uff0c\u9519\u8bef {}", (Object)vkException.getMessage());
            vkException.printStackTrace();
        }
        catch (Throwable e) {
            VkRenderSystem.LOGGER.error("Vulkan\u521d\u59cb\u5316\u5931\u8d25\uff0c\u53d1\u751f\u672a\u77e5\u9519\u8bef\uff0c\u5df2\u7981\u7528Vulkan\uff0c\u9519\u8bef {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        vulkan = null;
    }

    public static GlRenderSystem opengl() {
        return opengl;
    }

    public static VkRenderSystem vulkan() {
        return vulkan;
    }

    public static GlRenderSystem current() {
        return opengl;
    }
}

