/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.framebuffer;

import io.homo.superresolution.common.minecraft.MinecraftRenderTargetWrapper;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFilterMode;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureMipmapSettings;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.impl.texture.TextureWrapMode;

public class FrameBufferTextureAdapter
implements ITexture {
    private final IFrameBuffer frameBuffer;
    private final FrameBufferAttachmentType attachmentType;

    FrameBufferTextureAdapter(IFrameBuffer frameBuffer, FrameBufferAttachmentType attachmentType) {
        this.frameBuffer = frameBuffer;
        this.attachmentType = attachmentType;
    }

    public static FrameBufferTextureAdapter ofColor(IFrameBuffer frameBuffer) {
        return FrameBufferTextureAdapter.of(frameBuffer, FrameBufferAttachmentType.Color);
    }

    public static FrameBufferTextureAdapter ofDepth(IFrameBuffer frameBuffer) {
        return FrameBufferTextureAdapter.of(frameBuffer, FrameBufferAttachmentType.AnyDepth);
    }

    public static FrameBufferTextureAdapter of(IFrameBuffer frameBuffer, FrameBufferAttachmentType attachmentType) {
        return new FrameBufferTextureAdapter(frameBuffer, attachmentType);
    }

    @Override
    public long handle() {
        return this.frameBuffer.getTextureId(this.attachmentType);
    }

    @Override
    public TextureFormat getTextureFormat() {
        return this.attachmentType.equals((Object)FrameBufferAttachmentType.Color) ? this.frameBuffer.getColorTextureFormat() : this.frameBuffer.getDepthTextureFormat();
    }

    @Override
    public TextureUsages getTextureUsages() {
        if (this.frameBuffer instanceof MinecraftRenderTargetWrapper) {
            return TextureUsages.create().storage().sampler();
        }
        return this.frameBuffer.getTexture(this.attachmentType).getTextureUsages();
    }

    @Override
    public TextureType getTextureType() {
        if (this.frameBuffer instanceof MinecraftRenderTargetWrapper) {
            return TextureType.Texture2D;
        }
        return this.frameBuffer.getTexture(this.attachmentType).getTextureType();
    }

    @Override
    public TextureFilterMode getTextureFilterMode() {
        if (this.frameBuffer instanceof MinecraftRenderTargetWrapper) {
            return TextureFilterMode.Nearest;
        }
        return this.frameBuffer.getTexture(this.attachmentType).getTextureFilterMode();
    }

    @Override
    public TextureWrapMode getTextureWrapMode() {
        if (this.frameBuffer instanceof MinecraftRenderTargetWrapper) {
            return TextureWrapMode.ClampToEdge;
        }
        return this.frameBuffer.getTexture(this.attachmentType).getTextureWrapMode();
    }

    @Override
    public TextureMipmapSettings getMipmapSettings() {
        if (this.frameBuffer instanceof MinecraftRenderTargetWrapper) {
            return TextureMipmapSettings.disabled();
        }
        return this.frameBuffer.getTexture(this.attachmentType).getMipmapSettings();
    }

    @Override
    public TextureDescription getTextureDescription() {
        return TextureDescription.create().filterMode(this.getTextureFilterMode()).format(this.getTextureFormat()).size(this.getWidth(), this.getHeight()).type(this.getTextureType()).wrapMode(this.getTextureWrapMode()).mipmapSettings(this.getMipmapSettings()).usages(this.getTextureUsages()).build();
    }

    @Override
    public int getWidth() {
        return this.frameBuffer.getWidth();
    }

    @Override
    public int getHeight() {
        return this.frameBuffer.getHeight();
    }

    @Override
    public void destroy() {
        throw new UnsupportedOperationException("This method is not implemented yet.");
    }

    @Override
    public void resize(int width, int height) {
        throw new UnsupportedOperationException("This method is not implemented yet.");
    }
}

