/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.opengl;

import io.homo.superresolution.core.graphics.impl.BlendFactor;
import io.homo.superresolution.core.graphics.impl.DepthFunc;
import io.homo.superresolution.core.graphics.system.IRenderState;
import java.util.Stack;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class GlRenderState
implements IRenderState {
    private final Stack<IRenderState.StateSnapshot> snapshotStack = new Stack();
    private final float[] viewport = new float[4];
    private boolean depthTest = false;
    private boolean depthWrite = true;
    private boolean blend = false;
    private boolean cullFace = false;
    private boolean stencilTest = false;
    private boolean colorMaskR = true;
    private boolean colorMaskG = true;
    private boolean colorMaskB = true;
    private boolean colorMaskA = true;
    private BlendFactor blendSrcFactor = BlendFactor.One;
    private BlendFactor blendDstFactor = BlendFactor.Zero;
    private DepthFunc depthFunc = DepthFunc.Less;

    public void updateFromOpenGL() {
        this.depthTest = GL11.glGetBoolean((int)2929);
        this.depthWrite = GL11.glGetBoolean((int)2930);
        this.blend = GL11.glGetBoolean((int)3042);
        this.cullFace = GL11.glGetBoolean((int)2884);
        this.stencilTest = GL11.glGetBoolean((int)2960);
        int[] colorMask = new int[4];
        GL11.glGetIntegerv((int)3107, (int[])colorMask);
        this.colorMaskR = colorMask[0] == 1;
        this.colorMaskG = colorMask[1] == 1;
        this.colorMaskB = colorMask[2] == 1;
        this.colorMaskA = colorMask[3] == 1;
        int srcRGB = GL11.glGetInteger((int)32969);
        int dstRGB = GL11.glGetInteger((int)32968);
        this.blendSrcFactor = this.fromGlBlendFactor(srcRGB);
        this.blendDstFactor = this.fromGlBlendFactor(dstRGB);
        int depthFuncValue = GL11.glGetInteger((int)2932);
        this.depthFunc = this.fromGlDepthFunc(depthFuncValue);
        int[] viewportInt = new int[4];
        GL11.glGetIntegerv((int)2978, (int[])viewportInt);
        this.viewport[0] = viewportInt[0];
        this.viewport[1] = viewportInt[1];
        this.viewport[2] = viewportInt[2];
        this.viewport[3] = viewportInt[3];
    }

    private BlendFactor fromGlBlendFactor(int glFactor) {
        return switch (glFactor) {
            case 0 -> BlendFactor.Zero;
            case 1 -> BlendFactor.One;
            case 768 -> BlendFactor.SrcColor;
            case 769 -> BlendFactor.OneMinusSrcColor;
            case 774 -> BlendFactor.DstColor;
            case 775 -> BlendFactor.OneMinusDstColor;
            case 770 -> BlendFactor.SrcAlpha;
            case 771 -> BlendFactor.OneMinusSrcAlpha;
            case 772 -> BlendFactor.DstAlpha;
            case 773 -> BlendFactor.OneMinusDstAlpha;
            default -> BlendFactor.One;
        };
    }

    private DepthFunc fromGlDepthFunc(int glFunc) {
        return switch (glFunc) {
            case 512 -> DepthFunc.Never;
            case 513 -> DepthFunc.Less;
            case 514 -> DepthFunc.Equal;
            case 515 -> DepthFunc.LessEqual;
            case 516 -> DepthFunc.Greater;
            case 517 -> DepthFunc.NotEqual;
            case 518 -> DepthFunc.GreaterEqual;
            case 519 -> DepthFunc.Always;
            default -> DepthFunc.Less;
        };
    }

    private int toGlBlendFactor(BlendFactor bf) {
        return switch (bf) {
            case BlendFactor.Zero -> 0;
            case BlendFactor.One -> 1;
            case BlendFactor.SrcColor -> 768;
            case BlendFactor.OneMinusSrcColor -> 769;
            case BlendFactor.DstColor -> 774;
            case BlendFactor.OneMinusDstColor -> 775;
            case BlendFactor.SrcAlpha -> 770;
            case BlendFactor.OneMinusSrcAlpha -> 771;
            case BlendFactor.DstAlpha -> 772;
            case BlendFactor.OneMinusDstAlpha -> 773;
            default -> 1;
        };
    }

    private int toGlDepthFunc(DepthFunc func) {
        return switch (func) {
            case DepthFunc.Never -> 512;
            case DepthFunc.Less -> 513;
            case DepthFunc.Equal -> 514;
            case DepthFunc.LessEqual -> 515;
            case DepthFunc.Greater -> 516;
            case DepthFunc.NotEqual -> 517;
            case DepthFunc.GreaterEqual -> 518;
            case DepthFunc.Always -> 519;
            default -> 513;
        };
    }

    @Override
    public float[] viewport() {
        int[] viewportInt = new int[4];
        GL11.glGetIntegerv((int)2978, (int[])viewportInt);
        return new float[]{viewportInt[0], viewportInt[1], viewportInt[2], viewportInt[3]};
    }

    @Override
    public IRenderState viewport(float x, float y, float w, float h) {
        this.viewport[0] = x;
        this.viewport[1] = y;
        this.viewport[2] = w;
        this.viewport[3] = h;
        GL11.glViewport((int)((int)x), (int)((int)y), (int)((int)w), (int)((int)h));
        return this;
    }

    @Override
    public boolean depthTest() {
        return GL11.glGetBoolean((int)2929);
    }

    @Override
    public boolean depthWrite() {
        return GL11.glGetBoolean((int)2930);
    }

    @Override
    public boolean blend() {
        return GL11.glGetBoolean((int)3042);
    }

    @Override
    public boolean cullFace() {
        return GL11.glGetBoolean((int)2884);
    }

    @Override
    public boolean stencilTest() {
        return GL11.glGetBoolean((int)2960);
    }

    @Override
    public boolean colorMaskR() {
        int[] mask = new int[4];
        GL11.glGetIntegerv((int)3107, (int[])mask);
        return mask[0] == 1;
    }

    @Override
    public boolean colorMaskG() {
        int[] mask = new int[4];
        GL11.glGetIntegerv((int)3107, (int[])mask);
        return mask[1] == 1;
    }

    @Override
    public boolean colorMaskB() {
        int[] mask = new int[4];
        GL11.glGetIntegerv((int)3107, (int[])mask);
        return mask[2] == 1;
    }

    @Override
    public boolean colorMaskA() {
        int[] mask = new int[4];
        GL11.glGetIntegerv((int)3107, (int[])mask);
        return mask[3] == 1;
    }

    @Override
    public BlendFactor blendSrcFactor() {
        int srcFactor = GL11.glGetInteger((int)32969);
        return this.fromGlBlendFactor(srcFactor);
    }

    @Override
    public BlendFactor blendDstFactor() {
        int dstFactor = GL11.glGetInteger((int)32968);
        return this.fromGlBlendFactor(dstFactor);
    }

    @Override
    public DepthFunc depthFunc() {
        int depthFuncValue = GL11.glGetInteger((int)2932);
        return this.fromGlDepthFunc(depthFuncValue);
    }

    @Override
    public IRenderState depthTest(boolean enable) {
        this.depthTest = enable;
        if (enable) {
            GL11.glEnable((int)2929);
        } else {
            GL11.glDisable((int)2929);
        }
        return this;
    }

    @Override
    public IRenderState depthWrite(boolean enable) {
        this.depthWrite = enable;
        GL11.glDepthMask((boolean)enable);
        return this;
    }

    @Override
    public IRenderState blend(boolean enable) {
        this.blend = enable;
        if (enable) {
            GL11.glEnable((int)3042);
        } else {
            GL11.glDisable((int)3042);
        }
        return this;
    }

    @Override
    public IRenderState cullFace(boolean enable) {
        this.cullFace = enable;
        if (enable) {
            GL11.glEnable((int)2884);
        } else {
            GL11.glDisable((int)2884);
        }
        return this;
    }

    @Override
    public IRenderState stencilTest(boolean enable) {
        this.stencilTest = enable;
        if (enable) {
            GL11.glEnable((int)2960);
        } else {
            GL11.glDisable((int)2960);
        }
        return this;
    }

    @Override
    public IRenderState colorMaskR(boolean enable) {
        this.colorMaskR = enable;
        GL11.glColorMask((boolean)this.colorMaskR, (boolean)this.colorMaskG, (boolean)this.colorMaskB, (boolean)this.colorMaskA);
        return this;
    }

    @Override
    public IRenderState colorMaskG(boolean enable) {
        this.colorMaskG = enable;
        GL11.glColorMask((boolean)this.colorMaskR, (boolean)this.colorMaskG, (boolean)this.colorMaskB, (boolean)this.colorMaskA);
        return this;
    }

    @Override
    public IRenderState colorMaskB(boolean enable) {
        this.colorMaskB = enable;
        GL11.glColorMask((boolean)this.colorMaskR, (boolean)this.colorMaskG, (boolean)this.colorMaskB, (boolean)this.colorMaskA);
        return this;
    }

    @Override
    public IRenderState colorMaskA(boolean enable) {
        this.colorMaskA = enable;
        GL11.glColorMask((boolean)this.colorMaskR, (boolean)this.colorMaskG, (boolean)this.colorMaskB, (boolean)this.colorMaskA);
        return this;
    }

    @Override
    public IRenderState blendSrcFactor(BlendFactor factor) {
        this.blendSrcFactor = factor;
        GL14.glBlendFunc((int)this.toGlBlendFactor(this.blendSrcFactor), (int)this.toGlBlendFactor(this.blendDstFactor));
        return this;
    }

    @Override
    public IRenderState blendDstFactor(BlendFactor factor) {
        this.blendDstFactor = factor;
        GL14.glBlendFunc((int)this.toGlBlendFactor(this.blendSrcFactor), (int)this.toGlBlendFactor(this.blendDstFactor));
        return this;
    }

    @Override
    public IRenderState depthFunc(DepthFunc func) {
        this.depthFunc = func;
        GL11.glDepthFunc((int)this.toGlDepthFunc(func));
        return this;
    }

    @Override
    public IRenderState.StateSnapshot get() {
        return new IRenderState.StateSnapshot(this);
    }
}

