/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.opengl.framebuffer;

import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFilterMode;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureMipmapSettings;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.impl.texture.TextureWrapMode;
import java.util.function.Supplier;

public class GlOnlyNameTexture
implements ITexture {
    private final Supplier<TextureFormat> textureFormatSupplier;
    private final Supplier<Integer> widthSupplier;
    private final Supplier<Integer> heightSupplier;
    private final Supplier<Long> handleSupplier;

    public GlOnlyNameTexture(Supplier<TextureFormat> textureFormatSupplier, Supplier<Integer> widthSupplier, Supplier<Integer> heightSupplier, Supplier<Long> handleSupplier) {
        this.textureFormatSupplier = textureFormatSupplier;
        this.widthSupplier = widthSupplier;
        this.heightSupplier = heightSupplier;
        this.handleSupplier = handleSupplier;
    }

    @Override
    public TextureFormat getTextureFormat() {
        return this.textureFormatSupplier.get();
    }

    @Override
    public TextureUsages getTextureUsages() {
        return TextureUsages.create().sampler().storage();
    }

    @Override
    public TextureType getTextureType() {
        return TextureType.Texture2D;
    }

    @Override
    public TextureFilterMode getTextureFilterMode() {
        return TextureFilterMode.Nearest;
    }

    @Override
    public TextureWrapMode getTextureWrapMode() {
        return TextureWrapMode.ClampToEdge;
    }

    @Override
    public TextureMipmapSettings getMipmapSettings() {
        return TextureMipmapSettings.disabled();
    }

    @Override
    public TextureDescription getTextureDescription() {
        return TextureDescription.create().filterMode(this.getTextureFilterMode()).format(this.getTextureFormat()).size(this.getWidth(), this.getHeight()).type(this.getTextureType()).wrapMode(this.getTextureWrapMode()).mipmapSettings(this.getMipmapSettings()).usages(this.getTextureUsages()).build();
    }

    @Override
    public int getWidth() {
        return this.widthSupplier.get();
    }

    @Override
    public int getHeight() {
        return this.heightSupplier.get();
    }

    @Override
    public long handle() {
        return this.handleSupplier.get();
    }

    @Override
    public void destroy() {
    }

    @Override
    public void resize(int width, int height) {
    }
}

