/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.vulkan.command;

import io.homo.superresolution.core.graphics.impl.command.ICommandBuffer;
import io.homo.superresolution.core.graphics.impl.command.ICommandDecoder;
import io.homo.superresolution.core.graphics.impl.command.ICommandEncoder;
import io.homo.superresolution.core.graphics.impl.command.commands.GpuCommand;
import io.homo.superresolution.core.graphics.impl.device.IDevice;
import io.homo.superresolution.core.graphics.opengl.command.GlCommandDecoder;
import io.homo.superresolution.core.graphics.vulkan.VulkanDevice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.lwjgl.vulkan.VkCommandBuffer;

public class VulkanCommandBuffer
implements ICommandBuffer {
    private final List<GpuCommand> gpuCommands = new ArrayList<GpuCommand>();
    private final VulkanDevice vulkanDevice;
    private VkCommandBuffer nativeCommandBuffer;

    public VkCommandBuffer getNativeCommandBuffer() {
        return this.nativeCommandBuffer;
    }

    public VulkanCommandBuffer(VulkanDevice vulkanDevice) {
        this.vulkanDevice = vulkanDevice;
        this.nativeCommandBuffer = vulkanDevice.getCommandManager().createCommandBuffer();
    }

    @Override
    public void addCommand(GlCommandDecoder decoder, GpuCommand command) {
        this.gpuCommands.add(command);
        this.vulkanDevice.commandDecoder().decodeCommand(this, command);
    }

    @Override
    public Collection<GpuCommand> getCommands() {
        return this.gpuCommands;
    }

    @Override
    public void destroy() {
        this.gpuCommands.clear();
        this.vulkanDevice.getCommandManager().freeCommandBuffer(this.nativeCommandBuffer);
        this.nativeCommandBuffer = null;
    }

    @Override
    public void submit(IDevice device) {
        device.submitCommandBuffer(this);
    }

    @Override
    public IDevice getDevice() {
        return this.vulkanDevice;
    }

    @Override
    public ICommandDecoder getDecoder() {
        return this.vulkanDevice.commandDecoder();
    }

    @Override
    public ICommandEncoder getEncoder() {
        return this.vulkanDevice.commandEncoder();
    }
}

